package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PowerButton extends ImageButton {
    private final IMPBaseContainerScreen<?> screen;
    private final ResourceLocation resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int textureWidth;
    private final int textureHeight;

    public PowerButton(IMPBaseContainerScreen<?> screen, int x, int y, int width, int height, int xTexStart, int yTexStart, ResourceLocation resourceLocation, int textureWidth, int textureHeight) {
        super(x, y, width, height, xTexStart, yTexStart, height, resourceLocation, textureWidth, textureHeight, button -> onPower(screen), Component.m_237115_("imp.button.power"));
        this.screen = screen;
        this.resourceLocation = resourceLocation;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    public void m_6303_(PoseStack poseStack, int i, int j, float f) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_(0, this.resourceLocation);
        int tx = this.xTexStart;
        int ty = this.yTexStart;

        if (this.m_198029_())
            ty += this.f_93619_;

        if (screen.isPowered())
            tx += this.f_93618_;

        RenderSystem.m_69482_();
        m_93133_(poseStack, this.f_93620_, this.f_93621_, (float) tx, (float) ty, this.f_93618_, this.f_93619_, this.textureWidth, this.textureHeight);
        if (this.m_198029_())
            this.m_7428_(poseStack, i, j);
    }

    private static void onPower(IMPBaseContainerScreen<?> screen) {
        screen.insPower(!screen.isPowered());
    }
}
