package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SmartButton extends Button implements IIMPSmartRender {
    private boolean center = true;
    private ResourceLocation iconTexture;
    private int iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight;
    private boolean hideText;

    public SmartButton(int x, int y, int w, int h, Component text, OnPress onPress, OnTooltip onTooltip) {
        super(x, y, w, h, text, onPress, onTooltip);
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public SmartButton(int x, int y, int w, int h, Component text, OnPress onPress) {
        super(x, y, w, h, text, onPress);
    }

    public void setHideText(boolean hideText) {
        this.hideText = hideText;
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mx, int my, float f) {
        drawSmartButtonBox(poseStack, f_93620_, f_93621_, f_93618_, f_93619_, this.m_7202_(this.m_198029_()));
        float fx = center ? (float) (f_93618_ - mc.f_91062_.m_92852_(m_6035_())) / 2f : 2;
        float fy = (float) (f_93619_ - 7) / 2f;

        if (iconTexture != null) {
            float itx = hideText ? (f_93618_ - iconWidth) / 2f : 2;
            float ity = (float) (f_93619_ - iconHeight) / 2f;
            fx += itx + iconWidth;
            OERenderUtils.drawTexture(iconTexture, poseStack, f_93620_ + itx, f_93621_ + ity, iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight);
        }

        if (!hideText)
            drawSmartText(poseStack, m_6035_(), f_93620_ + fx, f_93621_ + fy);

        if (this.m_198029_())
            this.m_7428_(poseStack, mx, my);
    }

    public void setIcon(ResourceLocation location, int stX, int stY, int w, int h) {
        setIcon(location, stX, stY, w, h, 256, 256);
    }

    public void setIcon(ResourceLocation location, int stX, int stY, int w, int h, int texW, int texH) {
        setCenter(false);
        this.iconTexture = location;
        this.iconStX = stX;
        this.iconStY = stY;
        this.iconWidth = w;
        this.iconHeight = h;
        this.textureWidth = texW;
        this.textureHeight = texH;
    }

}
