package dev.felnull.imp.client.music.tracker;

import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

import java.util.function.Supplier;

public class EntityMusicTracker implements IMusicTracker {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final int entityID;
    private Vec3 pos;

    public EntityMusicTracker(CompoundTag tag) {
        this(new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z")), tag.m_128451_("id"));
    }

    public EntityMusicTracker(Vec3 pos, int entityID) {
        this.entityID = entityID;
        this.pos = pos;
    }

    @Override
    public Supplier<Vec3> getPosition() {
        return () -> {
            if (mc.f_91073_ != null) {
                var en = mc.f_91073_.m_6815_(entityID);
                if (en != null)
                    this.pos = en.m_20182_();
            }
            return pos;
        };
    }
}
