package dev.felnull.imp.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.integration.PatchouliIntegration;
import dev.felnull.imp.item.ManualItem;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class ManualItemRenderer implements BEWLItemRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Component FELNULL_DEV_TEXT = Component.m_237113_("FelNull DEV");
    private static final Component MANUAL_TEXT = Component.m_237115_("imp.text.manual");
    private static final Component COVER_INFO_TEXT = Component.m_237115_("imp.text.manual.coverInfo");
    private final Component MOD_NAME_TEXT;
    private final Component MOD_VERSION_TEXT;
    private int openProgress;
    private int openProgressO;

    public ManualItemRenderer() {
        var mod = Platform.getMod(IamMusicPlayer.MODID);
        this.MOD_NAME_TEXT = Component.m_237113_(mod.getName());
        this.MOD_VERSION_TEXT = Component.m_237113_("v" + mod.getVersion());
    }

    @Override
    public void render(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource multiBufferSource, float f, int light, int overlay) {
        var model = IMPModels.MANUAL.get();
        var vc = ItemRenderer.m_115222_(multiBufferSource, Sheets.m_110789_(), true, stack.m_41790_()); //multiBufferSource.getBuffer(Sheets.cutoutBlockSheet());
        float par = Mth.m_14179_(f, openProgressO, openProgress) / 10f;
        poseStack.m_85836_();
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            OERenderUtils.poseTrans16(poseStack, 11, 0, 0);
            OERenderUtils.poseRotateZ(poseStack, -25 * par);
            OERenderUtils.poseTrans16(poseStack, -11, 0, 0);
        }

        OERenderUtils.renderModel(poseStack, vc, model, light, overlay);

        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            OERenderUtils.poseTrans16(poseStack, 0, 0.125 * par, 0);
            OERenderUtils.poseTrans16(poseStack, 10, 0.125, 0);
            OERenderUtils.poseRotateZ(poseStack, -135 * par);
            OERenderUtils.poseTrans16(poseStack, -10, -0.125, 0);
        }

        OERenderUtils.poseTrans16(poseStack, 0, 0.125, 0);
        renderTurning(poseStack, multiBufferSource, vc, light, overlay);
        poseStack.m_85849_();
    }

    public void tick() {
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            openProgress = 0;
            openProgressO = 0;
            return;
        }
        if (mc.m_91104_()) return;
        openProgressO = openProgress;
        if (PatchouliIntegration.INSTANCE.isEnable() && ManualItem.MANUAL_BOOK.equals(PatchouliIntegration.INSTANCE.getOpenBookGui())) {
            openProgress = Math.min(openProgress + 1, 10);
        } else {
            openProgress = Math.max(openProgress - 1, 0);
        }
    }

    private void renderTurning(PoseStack poseStack, MultiBufferSource multiBufferSource, VertexConsumer vc, int light, int overlay) {
        var model = IMPModels.MANUAL_TURNING.get();
        poseStack.m_85836_();
        OERenderUtils.renderModel(poseStack, vc, model, light, overlay);
        renderText(poseStack, multiBufferSource, FELNULL_DEV_TEXT, light, 9f, 15.75f, 0.4f, false, 0);
        renderText(poseStack, multiBufferSource, MANUAL_TEXT, light, 4.225f / 2f, 15.75f, 0.54f, true, 0xFFFFFFFF);
        renderText(poseStack, multiBufferSource, MOD_NAME_TEXT, light, 9.85f, 14.5f, 0.7f, false, 0);
        renderText(poseStack, multiBufferSource, MOD_VERSION_TEXT, light, 9.85f, 13.5f, 0.4f, false, 0);
        renderText(poseStack, multiBufferSource, COVER_INFO_TEXT, light, 11f / 2f, 12, 0.4f, true, 0);
        poseStack.m_85849_();
    }

    private void renderText(PoseStack poseStack, MultiBufferSource multiBufferSource, Component text, int light, float x, float y, float scale, boolean center, int color) {
        poseStack.m_85836_();
        poseStack.m_85837_(0, OERenderUtils.MIN_BREADTH, 0);
        OERenderUtils.poseTrans16(poseStack, x, 0.125, y);
        OERenderUtils.poseRotateX(poseStack, -90f);
        OERenderUtils.poseRotateZ(poseStack, 180f);
        if (center) {
            OERenderUtils.renderCenterTextSprite(poseStack, multiBufferSource, text, 0, 0, 0, scale, 0, mc.f_91062_.f_92710_, color, light);
        } else {
            OERenderUtils.renderTextSprite(poseStack, multiBufferSource, text, 0, 0, 0, scale, 0, mc.f_91062_.f_92710_, color, light);
        }
        poseStack.m_85849_();
    }
}
