package dev.felnull.imp.data;

import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.item.IMPItemTags;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.RecipeProviderWrapper;
import dev.felnull.otyacraftengine.tag.PlatformItemTags;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;

import java.util.function.Consumer;

public class IMPRecipeProviderWrapper extends RecipeProviderWrapper {
    public IMPRecipeProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    @Override
    public void generateRecipe(Consumer<FinishedRecipe> exporter, RecipeProviderAccess providerAccess) {
        ShapelessRecipeBuilder.m_126189_(IMPItems.MANUAL.get())
                .m_126209_(Items.f_42517_)
                .m_206419_(IMPItemTags.CASSETTE_TAPE)
                .m_126132_(providerAccess.getHasName(Items.f_42517_), providerAccess.has(Items.f_42517_))
                .m_176498_(exporter);

        ShapelessRecipeBuilder.m_126189_(IMPItems.CASSETTE_TAPE.get())
                .m_206419_(PlatformItemTags.ironNuggets().getKey())
                .m_206419_(PlatformItemTags.stone().getKey())
                .m_206419_(PlatformItemTags.redstoneDusts())
                .m_126209_(Items.f_42576_)
                .m_126132_(providerAccess.getHasName(Items.f_42576_), providerAccess.has(Items.f_42576_))
                .m_176498_(exporter);

        ShapelessRecipeBuilder.m_126189_(IMPItems.CASSETTE_TAPE_GLASS.get())
                .m_206419_(PlatformItemTags.ironNuggets().getKey())
                .m_206419_(PlatformItemTags.glassBlocks())
                .m_206419_(PlatformItemTags.redstoneDusts())
                .m_126209_(Items.f_42576_)
                .m_126132_(providerAccess.getHasName(Items.f_42576_), providerAccess.has(Items.f_42576_))
                .m_176498_(exporter);

        ShapedRecipeBuilder.m_126116_(IMPItems.RADIO_ANTENNA.get())
                .m_206416_('E', PlatformItemTags.enderPearls().getKey())
                .m_206416_('I', PlatformItemTags.ironIngots())
                .m_126130_("E")
                .m_126130_("I")
                .m_126130_("I")
                .m_126145_("antenna")
                .m_126132_(providerAccess.getHasName(Items.f_42584_), providerAccess.has(PlatformItemTags.enderPearls().getKey()))
                .m_176498_(exporter);

        ShapedRecipeBuilder.m_126116_(IMPBlocks.BOOMBOX.get())
                .m_206416_('T', PlatformItemTags.ironNuggets().getKey())
                .m_206416_('I', PlatformItemTags.ironIngots())
                .m_126127_('N', Items.f_41859_)
                .m_126127_('J', Items.f_41984_)
                .m_206416_('B', ItemTags.f_13171_)
                .m_126130_("TBT")
                .m_126130_("NJN")
                .m_126130_("III")
                .m_126132_(providerAccess.getHasName(Items.f_41984_), providerAccess.has(Items.f_41984_))
                .m_176498_(exporter);

        ShapedRecipeBuilder.m_126116_(IMPBlocks.CASSETTE_DECK.get())
                .m_206416_('R', PlatformItemTags.redstoneDusts())
                .m_206416_('I', PlatformItemTags.ironIngots())
                .m_126127_('N', Items.f_41859_)
                .m_126127_('J', Items.f_41984_)
                .m_126130_("IRI")
                .m_126130_("NJN")
                .m_126130_("III")
                .m_126132_(providerAccess.getHasName(Items.f_41984_), providerAccess.has(Items.f_41984_))
                .m_176498_(exporter);

        ShapedRecipeBuilder.m_126116_(IMPBlocks.MUSIC_MANAGER.get())
                .m_206416_('D', PlatformItemTags.diamonds())
                .m_206416_('I', PlatformItemTags.ironIngots())
                .m_206416_('G', PlatformItemTags.glassPanes())
                .m_206416_('R', PlatformItemTags.redstoneBlocks().getKey())
                .m_206416_('B', PlatformItemTags.diamonds())
                .m_126130_("III")
                .m_126130_("DGR")
                .m_126130_("BII")
                .m_126132_(providerAccess.getHasName(Items.f_42415_), providerAccess.has(Items.f_42415_))
                .m_176498_(exporter);
    }
}
