package dev.felnull.imp.item;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;

public class BoomboxEntityRinger implements IBoomboxRinger {
    private final Entity entity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxEntityRinger(Entity entity, UUID uuid) {
        this.entity = entity;
        this.uuid = uuid;
    }

    @Override
    public Component getRingerName() {
        if (entity instanceof ItemEntity)
            return Component.m_237110_("imp.ringer.drop", getBoombox().m_41611_());

        return Component.m_237110_("imp.ringer.have", getBoombox().m_41611_(), entity.m_5446_());
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel) entity.f_19853_;
    }

    @Override
    public UUID getRingerUUID() {
        return uuid;
    }

    @Override
    public boolean exists() {
        return canRing(entity) && !getBoombox().m_41619_();
    }

    @Override
    public Pair<ResourceLocation, CompoundTag> getRingerTracker() {
        if (entity instanceof Player player)
            return Pair.of(MusicRingManager.PLAYER_TRACKER, MusicRingManager.createPlayerTracker(player));
        return Pair.of(MusicRingManager.ENTITY_TRACKER, MusicRingManager.createEntityTracker(entity));
    }

    @Override
    public @NotNull
    Vec3 getRingerSpatialPosition() {
        return entity.m_20182_();
    }

    @NotNull
    private ItemStack getBoombox() {
        if (entity instanceof LivingEntity livingEntity) {
            for (EquipmentSlot value : EquipmentSlot.values()) {
                var item = livingEntity.m_6844_(value);
                if (uuid.equals(BoomboxItem.getRingerUUID(item)))
                    return item;
            }
        }
        if (entity instanceof Player player) {
            var li = player.m_150109_().m_8020_(lastInventory);
            if (uuid.equals(BoomboxItem.getRingerUUID(li)))
                return li;

            for (int i = 0; i < player.m_150109_().m_6643_(); i++) {
                var item = player.m_150109_().m_8020_(i);
                if (uuid.equals(BoomboxItem.getRingerUUID(item))) {
                    lastInventory = i;
                    return item;
                }
            }
        }
        if (IamMusicPlayer.CONFIG.dropItemRing && entity instanceof ItemEntity itemEntity) {
            var item = itemEntity.m_32055_();
            if (uuid.equals(BoomboxItem.getRingerUUID(item)))
                return item;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public @NotNull BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(getBoombox());
    }

    public static boolean canRing(Entity entity) {
        if (!entity.m_6084_()) return false;
        if (entity instanceof Player player)
            return !player.m_5833_();
        return true;
    }
}
