/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.IntValue;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.components.PlayBackControlWidget;
import dev.felnull.imp.client.gui.components.VolumeWidget;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class PlayBackBaseBMonitor
extends BoomboxMonitor {
    protected static final ResourceLocation PLAYING_BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/monitor/playing.png");
    protected static final ResourceLocation PLAYING_IMAGE_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/monitor/playing_image.png");
    private VolumeWidget volumeWidget;
    private PlayBackControlWidget playBackControlWidget;

    public PlayBackBaseBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.volumeWidget = this.addRenderWidget(new VolumeWidget(this.getStartX() + 168, this.getStartY() + 14, new IntValue(){

            public void accept(int value) {
                PlayBackBaseBMonitor.this.setVolume(value);
            }

            public int getAsInt() {
                return PlayBackBaseBMonitor.this.getScreen().getVolume();
            }
        }, () -> this.getScreen().isMute(), null));
        this.volumeWidget.f_93624_ = this.canPlay();
        this.playBackControlWidget = this.addRenderWidget(new PlayBackControlWidget(this.getStartX() + (this.isShortProgressBar() ? 38 : 2), this.getStartY() + 25, () -> this.getScreen().isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING, n -> {
            switch (n) {
                case PLAYING: {
                    this.getScreen().insPlaying(true);
                    break;
                }
                case STOP: {
                    this.getScreen().insPlaying(false);
                    break;
                }
                case PAUSE: {
                    this.getScreen().insPause();
                }
            }
        }));
        this.playBackControlWidget.f_93624_ = this.canPlay();
    }

    @Override
    public void tick() {
        super.tick();
        this.volumeWidget.f_93624_ = this.canPlay();
        this.playBackControlWidget.f_93624_ = this.canPlay();
        this.playBackControlWidget.f_93620_ = this.getStartX() + (this.isShortProgressBar() ? 38 : 2);
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        if (!this.canPlay()) {
            return;
        }
        OERenderUtils.drawTexture((ResourceLocation)PLAYING_BG_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (!this.getPlayBackImage().isEmpty()) {
            OERenderUtils.drawTexture((ResourceLocation)PLAYING_IMAGE_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        }
        int sx = 2;
        if (!this.getPlayBackImage().isEmpty()) {
            this.getPlayImageRenderer().draw(this.getPlayBackImage(), poseStack, this.getStartX() + 1, this.getStartY() + 1, this.height - 2);
            sx += this.height - 2;
        }
        this.drawSmartCenterText(poseStack, (Component)Component.m_237115_((String)OEClientUtils.getWidthOmitText((String)this.getPlayBackName(), (float)(this.width - sx - 2), (String)"...")), (float)(this.getStartX() + sx) + ((float)(this.width - sx) - 2.0f) / 2.0f, this.getStartY() + 3);
    }

    @Override
    public void renderAppearance(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        if (!this.canPlay(data)) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)0.002f);
        OERenderUtils.renderTextureSprite((ResourceLocation)PLAYING_BG_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        poseStack.m_85849_();
        if (!this.getPlayBackImage(data).isEmpty()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, (double)0.003f);
            OERenderUtils.renderTextureSprite((ResourceLocation)PLAYING_IMAGE_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
            poseStack.m_85849_();
        }
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        int sx = 2;
        if (!this.getPlayBackImage(data).isEmpty()) {
            this.getPlayImageRenderer().renderSprite(this.getPlayBackImage(data), poseStack, multiBufferSource, 1.0f * onPxW, monitorHeight - (float)(1 + this.height - 2) * onPxH, 0.004f, (float)(this.height - 3) * onPxH, i, j);
            sx += this.height - 2;
        }
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, (Component)Component.m_237115_((String)OEClientUtils.getWidthOmitText((String)this.getPlayBackName(data), (float)(this.width - sx - 2), (String)"...")), (float)sx + ((float)(this.width - sx) - 2.0f) / 2.0f, 4.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        this.renderVolumeSprite(poseStack, multiBufferSource, 168.0f, 14.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, data.getVolume(), data.isMute());
        this.renderPlayBackControl(poseStack, multiBufferSource, this.isShortProgressBar(data) ? 38.0f : 2.0f, 25.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, data.isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING);
    }

    private void setVolume(int volume) {
        this.getScreen().insVolume(volume);
    }

    @NotNull
    protected ImageInfo getPlayBackImage() {
        return this.getPlayBackImage(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract ImageInfo getPlayBackImage(BoomboxData var1);

    @NotNull
    protected String getPlayBackName() {
        return this.getPlayBackName(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract String getPlayBackName(BoomboxData var1);

    @NotNull
    protected String getPlayBackAuthor() {
        return this.getPlayBackAuthor(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract String getPlayBackAuthor(BoomboxData var1);

    @NotNull
    protected MusicSource getPlayBackSource() {
        return this.getPlayBackSource(this.getScreen().getBoomBoxData());
    }

    @NotNull
    protected abstract MusicSource getPlayBackSource(BoomboxData var1);

    protected boolean canPlay() {
        return this.canPlay(this.getScreen().getBoomBoxData());
    }

    protected boolean canPlay(BoomboxData data) {
        return true;
    }

    protected boolean isShortProgressBar(BoomboxData data) {
        return !this.getPlayBackImage(data).isEmpty();
    }

    protected boolean isShortProgressBar() {
        return this.isShortProgressBar(this.getScreen().getBoomBoxData());
    }

    protected boolean isShortTipProgressBar() {
        return false;
    }
}

