/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.components.RemoteMusicsFixedButtonsList;
import dev.felnull.imp.client.gui.components.RemotePlayListFixedButtonsList;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class RemotePlayBackSelectBMonitor
extends BoomboxMonitor {
    protected static final ResourceLocation REMOTE_PLAYBACK_SELECT_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/monitor/remote_playback_select.png");
    private final List<MusicPlayList> musicPlayLists = new ArrayList<MusicPlayList>();
    private final List<Music> musics = new ArrayList<Music>();
    private List<MusicPlayList> musicPlayListsCash;
    private List<Music> musicsCash;

    public RemotePlayBackSelectBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new RemotePlayListFixedButtonsList(this.getStartX() + 1, this.getStartY() + 1, this.musicPlayLists, (FixedButtonsList.PressEntry<MusicPlayList>)((FixedButtonsList.PressEntry)(fixedButtonsList, playList, i, i1) -> this.setSelectPlaylist(playList.getUuid())), n -> n.getUuid().equals(this.getSelectPlaylist())));
        this.addRenderWidget(new RemoteMusicsFixedButtonsList(this.getStartX() + 70, this.getStartY() + 1, this.musics, (FixedButtonsList.PressEntry<Music>)((FixedButtonsList.PressEntry)(fixedButtonsList, music, i, i1) -> {
            this.setMusic(music.getUuid());
            this.setMonitor(BoomboxData.MonitorType.REMOTE_PLAYBACK);
        })));
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)REMOTE_PLAYBACK_SELECT_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
    }

    @Override
    public void renderAppearance(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtils.renderTextureSprite((ResourceLocation)REMOTE_PLAYBACK_SELECT_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderFixedListSprite(poseStack, multiBufferSource, 1.0f, 1.0f, 0.002f, 68.0f, 35.0f, i, j, onPxW, onPxH, monitorHeight, this.getSyncManager().getMyPlayList(), 5, (poseStack1, multiBufferSource1, x, y, z, w, h, i1, j1, entry) -> {
            this.renderSmartButtonBoxSprite(poseStack1, multiBufferSource1, x, y, z + 0.001f, w, h, i1, j1, onPxW, onPxH, monitorHeight, entry.getUuid().equals(this.getSelectPlaylist(data)));
            float sx = 1.0f;
            ImageInfo img = entry.getImage();
            if (!img.isEmpty()) {
                sx += h - 2.0f + 1.0f;
                this.renderPlayListImage(poseStack1, multiBufferSource1, img, x + 1.0f, y + 1.0f, z + 0.003f, h - 2.0f, i1, j1, onPxW, onPxH, monitorHeight);
            }
            this.renderSmartTextSprite(poseStack1, multiBufferSource1, (Component)Component.m_237113_((String)OEClientUtils.getWidthOmitText((String)entry.getName(), (float)(w - sx - 2.0f + 20.0f), (String)"...")), x + sx, y + 0.25f, z + 0.003f, onPxW, onPxH, monitorHeight, this.getDefaultRenderTextScale() * 0.7f, i1);
        });
        this.renderFixedListSprite(poseStack, multiBufferSource, 70.0f, 1.0f, 0.002f, 129.0f, 35.0f, i, j, onPxW, onPxH, monitorHeight, this.getSyncManager().getMusics(this.getSelectPlaylist(data)), 5, (poseStack12, multiBufferSource12, x, y, z, w, h, i12, j12, entry) -> {
            this.renderSmartButtonBoxSprite(poseStack12, multiBufferSource12, x, y, z + 0.001f, w, h, i12, j12, onPxW, onPxH, monitorHeight, false);
            float sx = 1.0f;
            ImageInfo img = entry.getImage();
            if (!img.isEmpty()) {
                sx += h - 2.0f + 1.0f;
                this.renderPlayListImage(poseStack12, multiBufferSource12, img, x + 1.0f, y + 1.0f, z + 0.003f, h - 2.0f, i12, j12, onPxW, onPxH, monitorHeight);
            }
            this.renderSmartTextSprite(poseStack12, multiBufferSource12, (Component)Component.m_237113_((String)OEClientUtils.getWidthOmitText((String)entry.getName(), (float)(w - sx - 2.0f + 20.0f), (String)"...")), x + sx, y + 0.25f, z + 0.003f, onPxW, onPxH, monitorHeight, this.getDefaultRenderTextScale() * 0.7f, i12);
        });
    }

    @Override
    public void tick() {
        super.tick();
        if (this.musicPlayListsCash != this.getSyncManager().getMyPlayList()) {
            this.musicPlayListsCash = this.getSyncManager().getMyPlayList();
            this.updateList();
        }
        if (this.getSelectPlaylist() != null && this.musicsCash != this.getSyncManager().getMusics(this.getSelectPlaylist())) {
            this.musicsCash = this.getSyncManager().getMusics(this.getSelectPlaylist());
            this.updateMusics();
        }
    }

    private void setMusic(UUID musicId) {
        this.getScreen().insSelectedMusic(musicId);
    }

    private Music getMusic() {
        return this.getScreen().getBoomBoxData().getSelectedMusic();
    }

    private UUID getSelectPlaylist(BoomboxData data) {
        return data.getSelectedPlayList((Player)RemotePlayBackSelectBMonitor.mc.f_91074_);
    }

    private UUID getSelectPlaylist() {
        return this.getScreen().getBoomBoxData().getSelectedPlayList((Player)RemotePlayBackSelectBMonitor.mc.f_91074_);
    }

    private void updateList() {
        this.musicPlayLists.clear();
        if (this.musicPlayListsCash != null) {
            this.musicPlayLists.addAll(this.musicPlayListsCash);
        }
    }

    private void updateMusics() {
        this.musics.clear();
        if (this.musicsCash != null) {
            this.musics.addAll(this.musicsCash);
        }
    }

    private void setSelectPlaylist(UUID playlist) {
        this.getScreen().insSelectedPlayList(playlist);
    }
}

