/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicBaseMMMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailMusicMMMonitor
extends MusicBaseMMMonitor {
    private static final Component EDIT_TEXT = Component.m_237115_((String)"imp.button.edit");
    private static final Component DELETE_TEXT = Component.m_237115_((String)"imp.button.delete").m_130940_(ChatFormatting.DARK_RED);
    private SmartButton editButton;
    private SmartButton deleteButton;
    private String cashName;

    public DetailMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
        this.locked();
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.editButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, EDIT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.EDIT_MUSIC)));
        this.editButton.f_93624_ = this.canEdit();
        this.deleteButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 5 - 87, this.getStartY() + 180, 87, 15, DELETE_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.DELETE_MUSIC)));
        this.deleteButton.f_93624_ = this.canDelete();
        this.cashName = this.getName();
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        if (this.canEdit(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, EDIT_TEXT, true);
        }
        if (this.canDelete(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 5 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, DELETE_TEXT, true);
        }
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        this.setSelectedMusic(null);
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        this.editButton.f_93624_ = this.canEdit();
        this.deleteButton.f_93624_ = this.canDelete();
        if (!this.cashName.equals(this.getName())) {
            this.cashName = this.getName();
            this.nameEditBox.m_94144_(this.cashName);
        }
    }

    @Override
    @Nullable
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return null;
    }

    private boolean canEdit(MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        return m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId());
    }

    private boolean canDelete(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        return pl != null && pl.getAuthority().getAuthorityType(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId()).canMusicDelete() || m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId());
    }

    private boolean canEdit() {
        Music m = this.getSelectedMusic();
        return m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId());
    }

    private boolean canDelete() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        Music m = this.getSelectedMusic();
        return pl != null && pl.getAuthority().getAuthorityType(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId()).canMusicDelete() || m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.f_91074_.m_36316_().getId());
    }

    @Override
    @NotNull
    protected String getMusicAuthor(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getAuthor();
        }
        return "";
    }

    @Override
    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.PLAY_LIST;
    }

    @Override
    @NotNull
    protected String getMusicLoaderType(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getSource().getLoaderType();
        }
        return "";
    }

    @Override
    @NotNull
    protected ImageInfo getImage(MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected String getName(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getName();
        }
        return "";
    }

    @Override
    @NotNull
    protected MusicSource getMusicSource(@NotNull MusicManagerBlockEntity blockEntity) {
        Music m = this.getSelectedMusic(blockEntity);
        if (m != null) {
            return m.getSource();
        }
        return MusicSource.EMPTY;
    }

    private void setSelectedMusic(@Nullable UUID uuid) {
        this.getScreen().insSelectedMusic(uuid);
    }

    @Nullable
    private Music getSelectedMusic() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getSelectedMusic(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private Music getSelectedMusic(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<Music> sms;
        UUID id = this.getSelectedMusicRaw(musicManagerBlockEntity);
        UUID pl = this.getSelectedPlayList(musicManagerBlockEntity);
        if (id != null && pl != null && (sms = this.getSyncManager().getMusics(pl)) != null) {
            return sms.stream().filter(n -> id.equals(n.getUuid())).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedMusicRaw() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getSelectedMusicRaw(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedMusicRaw(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedMusic((Player)DetailMusicMMMonitor.mc.f_91074_);
    }

    protected MusicPlayList getSelectedMusicPlayList() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getSelectedMusicPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return this.getSyncManager().getMyPlayList().stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    @Nullable
    protected UUID getSelectedPlayList() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getSelectedPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getSelectedPlayList((Player)DetailMusicMMMonitor.mc.f_91074_);
    }
}

