/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SearchMusicsFixedButtonsList;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMedia;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SearchMusicMMMonitor
extends MusicManagerMonitor {
    private static final ResourceLocation SEARCH_MUSIC_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/monitor/search_music.png");
    private static final Component SEARCHING_TEXT = Component.m_237115_((String)"imp.text.searching");
    private final List<MusicMediaResult> searchMusics = new ArrayList<MusicMediaResult>();
    private SearchMusicsFixedButtonsList searchMusicsFixedButtonsList;
    private EditBox searchNameEditBox;
    private SearchThread searchThread;

    public SearchMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.searchMusicsFixedButtonsList = this.addRenderWidget(new SearchMusicsFixedButtonsList(this.getStartX() + 2, this.getStartY() + 25, 366, 172, 4, (Component)Component.m_237115_((String)"imp.fixedList.searchMusic"), this.searchMusics, (FixedButtonsList.PressEntry<MusicMediaResult>)((FixedButtonsList.PressEntry)(fixedButtonsList, searchMusicEntry, i, i1) -> {
            this.setMusicSourceName(searchMusicEntry.source().getIdentifier());
            this.getScreen().lastSearch = true;
            this.insMonitor(MusicManagerBlockEntity.MonitorType.ADD_MUSIC);
        })));
        this.searchNameEditBox = new EditBox(IIMPSmartRender.mc.f_91062_, this.getStartX() + 2, this.getStartY() + 11, 367, 12, (Component)Component.m_237115_((String)"imp.editBox.musicSearchName"));
        this.searchNameEditBox.m_94199_(300);
        this.searchNameEditBox.m_94144_(this.getMusicSearchName());
        this.searchNameEditBox.m_94151_(this::setMusicSearchName);
        this.addRenderWidget(this.searchNameEditBox);
        this.startMusicSearch(this.getMusicSearchName());
    }

    @Override
    public void depose() {
        super.depose();
        this.stopMusicSearch();
        this.searchMusics.clear();
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)SEARCH_MUSIC_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.searchMusics.isEmpty() && !this.getMusicSearchName().isEmpty() && this.searchThread != null && this.searchThread.isAlive()) {
            this.drawSmartText(poseStack, SEARCHING_TEXT, this.getStartX() + 3, this.getStartY() + 27);
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((ResourceLocation)SEARCH_MUSIC_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 2.0f, 11.0f, 0.003f, 367.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getMusicSearchName(blockEntity));
        this.renderScrollbarSprite(poseStack, multiBufferSource, 359.0f, 25.0f, 0.003f, 172.0f, i, j, onPxW, onPxH, monitorHeight, 0, 6);
    }

    private void startMusicSearch(String name) {
        this.stopMusicSearch();
        this.searchThread = new SearchThread(name);
        this.searchThread.start();
    }

    private void stopMusicSearch() {
        if (this.searchThread != null) {
            this.searchThread.stopped();
            this.searchThread = null;
        }
    }

    public String getMusicSearchName() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity2 = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicSearchName(blockEntity2);
        }
        return "";
    }

    public String getMusicSearchName(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicSearchName((Player)SearchMusicMMMonitor.mc.f_91074_);
    }

    private void setMusicSearchName(String name) {
        if (!this.getMusicSearchName().equals(name)) {
            this.startMusicSearch(name);
        }
        this.getScreen().insMusicSearchName(name);
    }

    private void setMusicSourceName(String name) {
        this.getScreen().insMusicSourceName(name);
    }

    public MusicMedia getRawMusicLoaderType() {
        return IMPMusicMedias.getAllMedia().get(this.getMusicLoaderType());
    }

    public String getMusicLoaderType() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity2 = (MusicManagerBlockEntity)blockEntity;
            return this.getMusicLoaderType(blockEntity2);
        }
        return "auto";
    }

    public String getMusicLoaderType(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMusicLoaderType((Player)SearchMusicMMMonitor.mc.f_91074_).isEmpty() ? "auto" : blockEntity.getMusicLoaderType((Player)SearchMusicMMMonitor.mc.f_91074_);
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_MUSIC;
    }

    private class SearchThread
    extends FlagThread {
        private final String name;

        public SearchThread(String name) {
            this.name = name;
        }

        public void run() {
            if (this.isStopped()) {
                return;
            }
            MusicMedia lt = SearchMusicMMMonitor.this.getRawMusicLoaderType();
            if (lt == null || !lt.isSearchable()) {
                return;
            }
            if (this.isStopped()) {
                return;
            }
            List<MusicMediaResult> slst = lt.search(this.name);
            if (this.isStopped()) {
                return;
            }
            this.setSearchMusics(slst);
        }

        private synchronized void setSearchMusics(List<MusicMediaResult> musics) {
            if (musics != null) {
                SearchMusicMMMonitor.this.searchMusics.clear();
                SearchMusicMMMonitor.this.searchMusics.addAll(musics);
            }
        }
    }
}

