/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.player.extras.stream;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class StreamInstance {
    private static final Logger log = LoggerFactory.getLogger(StreamInstance.class);
    private final AudioTrack track;
    private final AudioPlayer trackPlayer;
    private final int maximumFrameCount;
    private final AudioFrame[] ringBuffer;
    private final Set<Cursor> cursors;
    private boolean initialized;
    private boolean destroyed;
    private int absoluteOffset;
    private int frameCount;

    public StreamInstance(AudioTrack track, AudioPlayer trackPlayer, int maximumFrameCount) {
        this.track = track;
        this.trackPlayer = trackPlayer;
        this.maximumFrameCount = maximumFrameCount;
        this.ringBuffer = new AudioFrame[maximumFrameCount];
        this.cursors = new HashSet<Cursor>();
    }

    public AudioTrack getTrack() {
        return this.track;
    }

    public synchronized Cursor createCursor(Consumer<Cursor> detachListener) {
        if (this.destroyed) {
            return null;
        }
        this.initialize();
        Cursor cursor = new Cursor(this.getFreshOffset(), detachListener);
        this.cursors.add(cursor);
        return cursor;
    }

    public synchronized void shutdown() {
        this.destroy();
    }

    private void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            for (Cursor cursor : new ArrayList<Cursor>(this.cursors)) {
                cursor.detach();
                cursor.close();
            }
            if (this.initialized) {
                log.debug("Shutting down centralized stream for {}.", (Object)this.track.getInfo());
                this.trackPlayer.destroy();
            }
        }
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            log.debug("Initializing centralized stream for {}.", (Object)this.track.getInfo());
            this.trackPlayer.addListener(new Listener());
            this.trackPlayer.playTrack(this.track);
        }
    }

    private synchronized AudioFrame getFrame(Cursor cursor) {
        if (this.destroyed) {
            return null;
        }
        if (cursor.absoluteOffset < 0L || cursor.absoluteOffset < (long)this.absoluteOffset) {
            cursor.absoluteOffset = this.getFreshOffset();
        }
        if (cursor.absoluteOffset >= (long)(this.absoluteOffset + this.frameCount)) {
            AudioFrame newFrame = this.trackPlayer.provide();
            if (newFrame == null) {
                return null;
            }
            ++this.absoluteOffset;
            this.frameCount = Math.min(this.frameCount + 1, this.ringBuffer.length);
            int framePosition = this.getRelativeOffset(this.absoluteOffset + this.frameCount - 1);
            this.ringBuffer[framePosition] = newFrame;
            cursor.absoluteOffset++;
            return newFrame;
        }
        int framePosition = this.getRelativeOffset(cursor.absoluteOffset);
        cursor.absoluteOffset++;
        return this.ringBuffer[framePosition];
    }

    private synchronized void releaseCursor(Cursor cursor) {
        if (this.cursors.remove(cursor) && this.cursors.isEmpty()) {
            this.destroy();
        }
    }

    private long getFreshOffset() {
        return this.absoluteOffset + Math.max(0, this.frameCount - 1);
    }

    private int getRelativeOffset(long absoluteOffset) {
        return (int)(absoluteOffset % (long)this.maximumFrameCount);
    }

    private class Listener
    extends AudioEventAdapter {
        private Listener() {
        }

        @Override
        public void onEvent(AudioEvent event) {
            if (event instanceof TrackEndEvent || event instanceof TrackStuckEvent) {
                StreamInstance.this.destroy();
            }
        }
    }

    public class Cursor {
        private final Consumer<Cursor> detachListener;
        private final AtomicBoolean detached = new AtomicBoolean();
        private long absoluteOffset;

        private Cursor(long absoluteOffset, Consumer<Cursor> detachListener) {
            this.detachListener = detachListener;
            this.absoluteOffset = absoluteOffset;
        }

        public AudioTrack getTrack() {
            return StreamInstance.this.track;
        }

        public void close() {
            this.detach();
            StreamInstance.this.releaseCursor(this);
        }

        public AudioFrame provide() {
            return StreamInstance.this.getFrame(this);
        }

        private void detach() {
            if (this.detached.compareAndSet(false, true)) {
                this.detachListener.accept(this);
            }
        }
    }
}

