/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.handler.CommonHandler;
import dev.felnull.imp.item.BoomboxEntityRinger;
import dev.felnull.imp.item.BoomboxItemContainer;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.item.IInstructionItem;
import dev.felnull.otyacraftengine.item.ItemContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends BlockItem
implements IInstructionItem {
    public BoomboxItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_6883_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        super.m_6883_(itemStack, level, entity, i, bl);
        BoomboxItem.tick(level, entity, itemStack, false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if ((player.m_6047_() || BoomboxItem.isPowered(itemStack)) && !level.m_5776_()) {
            if (player.m_6047_()) {
                BoomboxItem.setPower(itemStack, !BoomboxItem.isPowered(itemStack));
            } else if (BoomboxItem.getTransferProgress(itemStack) == 10) {
                BoomboxItemContainer.openContainer((ServerPlayer)player, interactionHand, itemStack);
            }
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public InteractionResult m_40576_(BlockPlaceContext blockPlaceContext) {
        ItemStack itemStack = blockPlaceContext.m_43722_();
        Player player = blockPlaceContext.m_43723_();
        if (player != null && (player.m_6047_() || BoomboxItem.isPowered(itemStack))) {
            if (!blockPlaceContext.m_43725_().m_5776_()) {
                if (player.m_6047_()) {
                    BoomboxItem.setPower(itemStack, !BoomboxItem.isPowered(itemStack));
                } else if (BoomboxItem.getTransferProgress(itemStack) == 10) {
                    BoomboxItemContainer.openContainer((ServerPlayer)player, blockPlaceContext.m_43724_(), itemStack);
                }
            }
            return InteractionResult.FAIL;
        }
        return super.m_40576_(blockPlaceContext);
    }

    protected boolean m_40610_(BlockPlaceContext blockPlaceContext, @NotNull BlockState blockState) {
        return BoomboxItem.getTransferProgress(blockPlaceContext.m_43722_()) == 0 && super.m_40610_(blockPlaceContext, blockState);
    }

    public void m_142023_(@NotNull ItemEntity itemEntity) {
        if (this.m_40614_() instanceof BoomboxBlock) {
            ItemUtils.m_150952_((ItemEntity)itemEntity, (Stream)BoomboxItem.getContainItem(itemEntity.m_32055_()).stream());
        }
        super.m_142023_(itemEntity);
    }

    public static void tick(Level level, Entity entity, ItemStack stack, boolean musicOnly) {
        LivingEntity livingEntity;
        if (!stack.m_150930_(((Block)IMPBlocks.BOOMBOX.get()).m_5456_())) {
            return;
        }
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            MusicRingManager mr = MusicRingManager.getInstance();
            if (BoomboxItem.getRingerUUID(stack) == null || CommonHandler.itemBoomboxes.contains(BoomboxItem.getRingerUUID(stack))) {
                BoomboxItem.setRingerUUID(stack, UUID.randomUUID());
            }
            UUID uuid = BoomboxItem.getRingerUUID(stack);
            CommonHandler.itemBoomboxes.add(uuid);
            if (BoomboxEntityRinger.canRing(entity) && !mr.hasRinger(sl, uuid)) {
                mr.addRinger(sl, new BoomboxEntityRinger(entity, uuid));
            }
        }
        if (musicOnly) {
            return;
        }
        BoomboxData data = BoomboxItem.getData(stack);
        data.tick(level);
        BoomboxItem.setData(stack, data);
        if (entity instanceof LivingEntity && ((livingEntity = (LivingEntity)entity).m_21205_() == stack || livingEntity.m_21206_() == stack)) {
            boolean power = BoomboxItem.isPowered(stack);
            BoomboxItem.setTransferProgressOld(stack, BoomboxItem.getTransferProgress(stack));
            BoomboxItem.setTransferProgress(stack, BoomboxItem.getTransferProgress(stack) + (power ? 1 : -1));
        }
    }

    protected boolean m_7274_(@NotNull BlockPos blockPos, Level level, @Nullable Player player, @NotNull ItemStack itemStack, @NotNull BlockState blockState) {
        BlockEntity be;
        MinecraftServer server = level.m_7654_();
        if (server != null && (be = level.m_7702_(blockPos)) instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)be;
            boomboxBlockEntity.setByItem(itemStack);
            boomboxBlockEntity.m_6596_();
            super.m_7274_(blockPos, level, player, itemStack, blockState);
            return true;
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    public static boolean matches(ItemStack src, ItemStack target) {
        if (src == target) {
            return true;
        }
        UUID uid = BoomboxItem.getRingerUUID(src);
        return uid != null && uid.equals(BoomboxItem.getRingerUUID(target));
    }

    public static CompoundTag getBoomboxTag(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41783_().m_128469_("BoomboxTag") : null;
    }

    public static CompoundTag getOrCreateBoomboxTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("BoomboxTag")) {
            tag.m_128365_("BoomboxTag", (Tag)new CompoundTag());
        }
        return BoomboxItem.getBoomboxTag(stack);
    }

    public static BoomboxData getData(final ItemStack stack) {
        return new BoomboxData(BoomboxItem.getBoomboxTag(stack), new BoomboxData.DataAccess(){

            @Override
            public ItemStack getCassetteTape() {
                return BoomboxItem.getCassetteTape(stack);
            }

            @Override
            public ItemStack getAntenna() {
                return BoomboxItem.getAntenna(stack);
            }

            @Override
            public boolean isPowered() {
                return BoomboxItem.isPowered(stack);
            }

            @Override
            public void setPower(boolean power) {
                BoomboxItem.setPower(stack, power);
            }

            @Override
            public IMusicRinger getRinger() {
                return MusicRingManager.getInstance().getRinger(BoomboxItem.getRingerUUID(stack));
            }

            @Override
            public Vec3 getPosition() {
                return this.getRinger() != null ? this.getRinger().getRingerSpatialPosition() : Vec3.f_82478_;
            }

            @Override
            public void setCassetteTape(ItemStack cassette) {
                BoomboxItem.setCassetteTape(stack, cassette);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                BoomboxItem.setData(stack, data);
            }
        });
    }

    public static void setData(ItemStack stack, BoomboxData data) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128365_("BoomBoxData", (Tag)data.save(new CompoundTag(), true, true));
    }

    public static boolean isPowered(ItemStack itemStack) {
        if (BoomboxItem.getBoomboxTag(itemStack) != null) {
            return BoomboxItem.getBoomboxTag(itemStack).m_128471_("Power");
        }
        return false;
    }

    public static void setPower(ItemStack itemStack, boolean power) {
        BoomboxItem.getOrCreateBoomboxTag(itemStack).m_128379_("Power", power);
    }

    public static int getTransferProgress(ItemStack stack) {
        return BoomboxItem.getBoomboxTag(stack) != null ? BoomboxItem.getBoomboxTag(stack).m_128451_("Transfer") : 0;
    }

    public static void setTransferProgress(ItemStack stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128405_("Transfer", Mth.m_14045_((int)num, (int)0, (int)10));
    }

    public static int getTransferProgressOld(ItemStack stack) {
        return BoomboxItem.getBoomboxTag(stack) != null ? BoomboxItem.getBoomboxTag(stack).m_128451_("TransferOld") : 0;
    }

    public static void setTransferProgressOld(ItemStack stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128405_("TransferOld", Mth.m_14045_((int)num, (int)0, (int)10));
    }

    public static float getTransferProgress(ItemStack stack, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)BoomboxItem.getTransferProgressOld(stack), (float)BoomboxItem.getTransferProgress(stack)) / 10.0f;
    }

    public static UUID getRingerUUID(ItemStack stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null && BoomboxItem.getBoomboxTag(stack).m_128441_("Identification")) {
            return BoomboxItem.getBoomboxTag(stack).m_128342_("Identification");
        }
        return null;
    }

    public static void setRingerUUID(ItemStack stack, UUID id) {
        BoomboxItem.getOrCreateBoomboxTag(stack).m_128362_("Identification", id);
    }

    public static NonNullList<ItemStack> getContainItem(ItemStack stack) {
        NonNullList stacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
        ItemContainer.loadItemList((ItemStack)stack, (NonNullList)stacks, (String)"BoomboxItems");
        return stacks;
    }

    public static void setContainItem(ItemStack stack, NonNullList<ItemStack> stacks) {
        ItemContainer.saveItemList((ItemStack)stack, stacks, (String)"BoomboxItems");
    }

    public static void setCassetteTape(ItemStack stack, ItemStack cassette) {
        NonNullList<ItemStack> itms = BoomboxItem.getContainItem(stack);
        itms.set(0, (Object)cassette);
        BoomboxItem.setContainItem(stack, itms);
    }

    public static ItemStack getCassetteTape(ItemStack stack) {
        return (ItemStack)BoomboxItem.getContainItem(stack).get(0);
    }

    public static ItemStack getAntenna(ItemStack stack) {
        return (ItemStack)BoomboxItem.getContainItem(stack).get(1);
    }

    public CompoundTag onInstruction(ItemStack itemStack, ServerPlayer player, String name, CompoundTag data) {
        return BoomboxItem.getData(itemStack).onInstruction(player, name, data);
    }

    public static ItemStack createByBE(BoomboxBlockEntity blockEntity, boolean stopMusic) {
        ItemStack itemStack = new ItemStack((ItemLike)IMPBlocks.BOOMBOX.get());
        BoomboxItem.setContainItem(itemStack, blockEntity.getItems());
        BoomboxItem.setData(itemStack, blockEntity.getBoomboxData());
        BoomboxData d = BoomboxItem.getData(itemStack);
        if (stopMusic) {
            d.setPlaying(false);
            d.setMusicPosition(0L);
        }
        BoomboxItem.setData(itemStack, d);
        BoomboxItem.setPower(itemStack, blockEntity.isPowered());
        if (blockEntity.isPowered()) {
            BoomboxItem.setTransferProgress(itemStack, 10);
            BoomboxItem.setTransferProgressOld(itemStack, 10);
        }
        if (blockEntity.m_8077_()) {
            itemStack.m_41714_(blockEntity.m_7770_());
        }
        BoomboxItem.setRingerUUID(itemStack, UUID.randomUUID());
        return itemStack;
    }

    public static boolean checkDuplication(ItemStack stack, Entity entity) {
        UUID stackId = BoomboxItem.getRingerUUID(stack);
        if (stackId == null) {
            return false;
        }
        ArrayList<ItemStack> allItem = new ArrayList<ItemStack>();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (EquipmentSlot value : EquipmentSlot.values()) {
                allItem.add(livingEntity.m_6844_(value));
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            allItem.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        }
        for (ItemStack item : allItem) {
            if (item == stack || item.m_41619_() || !stackId.equals(BoomboxItem.getRingerUUID(item))) continue;
            return true;
        }
        return false;
    }
}

