package dev.felnull.imp.advancements;

import com.google.gson.JsonObject;
import dev.felnull.imp.IamMusicPlayer;
import net.minecraft.advancements.critereon.*;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class WriteCassetteTapeTrigger extends SimpleCriterionTrigger<WriteCassetteTapeTrigger.TriggerInstance> {
    private static final ResourceLocation ID = new ResourceLocation(IamMusicPlayer.MODID, "write_cassette_tape");

    @Override
    protected TriggerInstance m_7214_(JsonObject jsonObject, EntityPredicate.Composite composite, DeserializationContext deserializationContext) {
        ItemPredicate itemPredicate = ItemPredicate.m_45051_(jsonObject.get("item"));
        return new TriggerInstance(composite, itemPredicate);
    }

    public void trigger(ServerPlayer serverPlayer, ItemStack itemStack) {
        this.m_66234_(serverPlayer, (triggerInstance) -> triggerInstance.matches(itemStack));
    }

    @Override
    public ResourceLocation m_7295_() {
        return ID;
    }

    public static class TriggerInstance extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;

        public TriggerInstance(EntityPredicate.Composite composite, ItemPredicate itemPredicat) {
            super(ID, composite);
            this.item = itemPredicat;
        }

        public boolean matches(ItemStack itemStack) {
            return item.m_45049_(itemStack);
        }

        @Override
        public JsonObject m_7683_(SerializationContext serializationContext) {
            JsonObject jsonObject = super.m_7683_(serializationContext);
            if (this.item != null)
                jsonObject.add("item", this.item.m_45048_());
            return jsonObject;
        }

        public static TriggerInstance writeCassetteTape() {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, null);
        }
    }
}
