package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;

public class BoomboxBlockEntity extends IMPBaseEntityBlockEntity implements IBoomboxRinger {
    private final BoomboxData boomboxData;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_(2, ItemStack.f_41583_);
    private final UUID ringerUUID = UUID.randomUUID();

    public BoomboxBlockEntity(BlockPos blockPos, BlockState blockState) {

        super(IMPBlockEntities.BOOMBOX.get(), blockPos, blockState);
        this.boomboxData = new BoomboxData(null, new BoomboxData.DataAccess() {
            @Override
            public ItemStack getCassetteTape() {
                return BoomboxBlockEntity.this.getCassetteTape();
            }

            @Override
            public ItemStack getAntenna() {
                return BoomboxBlockEntity.this.getAntenna();
            }

            @Override
            public boolean isPowered() {
                return BoomboxBlockEntity.this.isPowered();
            }

            @Override
            public void setPower(boolean power) {
                BoomboxBlockEntity.this.setPower(power);
            }

            @Override
            public IMusicRinger getRinger() {
                return BoomboxBlockEntity.this;
            }

            @Override
            public Vec3 getPosition() {
                return new Vec3(m_58899_().m_123341_(), m_58899_().m_123342_(), m_58899_().m_123343_());
            }

            @Override
            public void setCassetteTape(ItemStack stack) {
                setItemNoUpdate(0, stack);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                m_6596_();
            }
        });
    }

    @Override
    public ItemStack m_7407_(int i, int j) {
        if (i == 0) {
            var old = m_8020_(0).m_41777_();
            var ret = super.m_7407_(i, j);
            this.boomboxData.setOldCassetteTape(old);
            return ret;
        }
        return super.m_7407_(i, j);
    }

    @Override
    public void m_6836_(int i, ItemStack stack) {
        if (i == 0)
            this.boomboxData.onCassetteTapeChange(stack, getCassetteTape());
        setItemNoUpdate(i, stack);
    }

    public void setItemNoUpdate(int i, ItemStack stack) {
        super.m_6836_(i, stack);
    }

    public void setBoomboxData(BoomboxData data) {
        boomboxData.load(data.save(new CompoundTag(), false, false), false, false);
    }

    @Override
    public ItemStack createRetainDropItem() {
        return BoomboxItem.createByBE(this, false);
    }

    @Override
    public boolean isRetainDrop() {
        return true;
    }

    @Override
    protected Component m_6820_() {
        return IMPBlocks.BOOMBOX.get().m_49954_();
    }

    @Override
    protected AbstractContainerMenu m_6555_(int i, @NotNull Inventory inventory) {
        return new BoomboxMenu(i, inventory, this, m_58899_(), ItemStack.f_41583_, null);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.boomboxData.load(tag.m_128469_("BoomBoxData"), false, false);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("BoomBoxData", this.boomboxData.save(new CompoundTag(), false, false));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BoomboxBlockEntity blockEntity) {
        blockEntity.boomboxData.tick(level);
        if (!level.m_5776_()) {
            blockEntity.ringerTick();
            blockEntity.setRaisedHandleState(blockEntity.boomboxData.getHandleRaisedProgress() >= blockEntity.boomboxData.getHandleRaisedMax());

            blockEntity.m_6596_();
        }

        blockEntity.baseAfterTick();
    }


    @Override
    public void saveToUpdateTag(CompoundTag tag) {
        super.saveToUpdateTag(tag);
        tag.m_128365_("BoomBoxData", this.boomboxData.save(new CompoundTag(), false, true));
    }

    @Override
    public void loadToUpdateTag(CompoundTag tag) {
        super.loadToUpdateTag(tag);
        this.boomboxData.load(tag.m_128469_("BoomBoxData"), false, true);
    }

    @Override
    public boolean m_7013_(int i, ItemStack itemStack) {
        return (i == 0 && IMPItemUtil.isCassetteTape(itemStack)) || (i == 1 && IMPItemUtil.isAntenna(itemStack));
    }

    @Override
    public @NotNull NonNullList<ItemStack> getItems() {
        return items;
    }

    public void setRaisedHandleState(boolean raised) {
        var bs = m_58900_().m_61124_(BoomboxBlock.RAISED, raised);
        m_58904_().m_7731_(m_58899_(), bs, 2);
    }

    public BoomboxData getBoomboxData() {
        return boomboxData;
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, CompoundTag data) {
        var ret = boomboxData.onInstruction(player, name, data);
        if (ret != null)
            return ret;
        return super.onInstruction(player, name, data);
    }

    public ItemStack getCassetteTape() {
        return m_8020_(0);
    }

    public ItemStack getAntenna() {
        return m_8020_(1);
    }

    @Override
    public Component getRingerName() {
        return m_6820_();
    }

    @Override
    public UUID getRingerUUID() {
        return ringerUUID;
    }

    @Override
    public boolean exists() {
        if (m_58904_() == null || f_58857_ != m_58904_()) return false;
        return m_58899_() != null && f_58857_.m_7702_(m_58899_()) == this;
    }

    @Override
    public @NotNull BoomboxData getRingerBoomboxData() {
        return boomboxData;
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel) this.f_58857_;
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
        return IMPMusicTrackers.createFixedTracker(getRingerSpatialPosition(), getRingerVolume(), getRingerRange());
//        return Pair.of(MusicRingManager.FIXED_TRACKER, MusicRingManager.createFixedTracker(getRingerSpatialPosition()));
    }

    @Override
    public @NotNull Vec3 getRingerSpatialPosition() {
        return new Vec3(m_58899_().m_123341_() + 0.5, m_58899_().m_123342_() + 0.5, m_58899_().m_123343_() + 0.5);
    }

    public void setByItem(ItemStack stack) {
        setPower(BoomboxItem.isPowered(stack));
        setItemNoUpdate(0, BoomboxItem.getCassetteTape(stack));
        setItemNoUpdate(1, BoomboxItem.getAntenna(stack));
        setBoomboxData(BoomboxItem.getData(stack));
        setPower(BoomboxItem.isPowered(stack));
        if (BoomboxItem.getTransferProgress(stack) == 0) {
            boomboxData.setHandleRaising(true);
            boomboxData.setHandleRaisedProgress(boomboxData.getHandleRaisedMax());
            boomboxData.setHandleRaisedProgressOld(boomboxData.getHandleRaisedMax());
        }
    }
}
