package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class PlaybackProgressBar extends AbstractButton {
    private final Supplier<Float> progressGetter;
    private final Consumer<Float> playbackProgressControl;

    public PlaybackProgressBar(int x, int y, Component component, Supplier<Float> progressGetter, Consumer<Float> playbackProgressControl) {
        super(x, y, 153, 3, component);
        this.progressGetter = progressGetter;
        this.playbackProgressControl = playbackProgressControl;
    }

    @Override
    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        if (m_198029_()) {
            if (e >= f_93621_ && e <= (f_93621_ + m_93694_()) && d >= f_93620_ && d <= (f_93620_ + m_5711_()))
                playbackProgressControl.accept((float) ((d - f_93620_) / m_5711_()));
        }
    }

    @Override
    public void m_5691_() {
    }

    @Override
    public void m_6303_(PoseStack poseStack, int i, int j, float f) {
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, f_93620_, f_93621_, 52, 54 + (m_198029_() ? 3 : 0), m_5711_(), m_93694_());
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, f_93620_, f_93621_, 52, 48 + (m_198029_() ? 3 : 0), (float) m_5711_() * progressGetter.get(), m_93694_());
    }

    @Override
    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_5646_());
    }
}
