package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.IntValue;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

import java.util.function.BooleanSupplier;

public class VolumeWidget extends AbstractWidget implements IIMPSmartRender {
    private final IntValue volume;
    private final BooleanSupplier mute;
    private final BooleanConsumer setMute;

    public VolumeWidget(int x, int y, IntValue volume, BooleanSupplier mute, BooleanConsumer setMute) {
        super(x, y, 30, 10, Component.m_237115_("imp.widget.volume"));
        this.volume = volume;
        this.mute = mute;
        this.setMute = setMute;
    }

    @Override
    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    @Override
    public void m_6303_(PoseStack poseStack, int i, int j, float f) {
        int vol = volume.get();
        boolean imute = mute.getAsBoolean();
        int nv = imute ? 3 : vol / 100;
        int lfs = (nv * 2) + (vol <= 0 ? 0 : 2);
        int z = m_198029_() ? 20 : 0;
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, f_93620_, f_93621_, z, 156, imute ? 4 : 4 + lfs, 8);
        if (imute)
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, f_93620_ + 3, f_93621_, 12 + z, 156, 8, 8);
        drawSmartText(poseStack, Component.m_237113_(String.valueOf(vol)), f_93620_ + 5 + lfs, f_93621_ + 0.5f, m_198029_() ? 0XFF007F06 : 0XFF115D0E);
    }

    @Override
    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        if (setMute != null)
            setMute.accept(!mute.getAsBoolean());
    }

    @Override
    public boolean m_6050_(double d, double e, double f) {
        float mv = 1;
        if (OEClientUtils.isKeyInput(mc.f_91066_.f_92090_))
            mv *= 10;
        if (OEClientUtils.isKeyInput(mc.f_91066_.f_92091_))
            mv *= 10;
        int an = (int) (mv * f);
        volume.accept(Mth.m_14045_(volume.get() + an, 0, 300));
        return true;
    }
}
