package dev.felnull.imp.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CassetteDeckScreen extends IMPBaseContainerScreen<CassetteDeckMenu> {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation(IamMusicPlayer.MODID, "textures/gui/container/cassette_deck/cassette_deck_base.png");
    public static final ResourceLocation EMPTY_CASSETTE_TAPE_SLOT = new ResourceLocation(IamMusicPlayer.MODID, "textures/gui/container/slot/cassette_tape_slot.png");
    private final Map<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor> monitors = new HashMap<>();
    protected CassetteDeckMonitor monitor;

    public CassetteDeckScreen(CassetteDeckMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
        this.f_97726_ = 214;
        this.f_97727_ = 176;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_(new PowerButton(this, f_97735_ + 185, f_97736_ + 79, 12, 12, 214, 0, BG_TEXTURE, bgTextureWidth, bgTextureHeight));


        changeScreenMonitor(getRawMonitorType());
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float f, int i, int j) {
        super.m_7286_(poseStack, f, i, j);
        if (getCassetteTape().m_41619_())
            OERenderUtils.drawTexture(EMPTY_CASSETTE_TAPE_SLOT, poseStack, f_97735_ + 183, f_97736_ + 99, 0, 0, 16, 16, 16, 16);

        if (monitor != null)
            monitor.render(poseStack, f, i, j);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (monitor != null) {
            if (getRawMonitorType() != monitor.getType())
                changeScreenMonitor(getRawMonitorType());
            monitor.tick();
        }
    }

    public long getPosition() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return getPosition(cassetteDeckBlockEntity);
        return 0;
    }

    public long getPosition(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getPosition();
    }

    public boolean isPlaying() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isPlaying(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isPlaying(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isPlaying();
    }

    public void insPositionAndRestart(long position) {
        var tag = new CompoundTag();
        tag.m_128356_("position", position);
        instruction("restat_and_set_position", tag);
    }


    public void insLoop(boolean loop) {
        var tag = new CompoundTag();
        tag.m_128379_("loop", loop);
        instruction("set_loop", tag);
    }

    public boolean isLoop() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isLoop(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isLoop(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoop();
    }

    private void changeScreenMonitor(CassetteDeckBlockEntity.MonitorType type) {
        if (monitor != null) {
            monitor.renderables.forEach(n -> {
                if (n instanceof GuiEventListener guiEventListener)
                    m_169411_(guiEventListener);
            });
            monitor.depose();
        }

        if (!monitors.containsKey(type))
            monitors.put(type, CassetteDeckMonitor.createdCassetteDeckMonitor(type, this));

        monitor = monitors.get(type);
        monitor.init(f_97735_, f_97736_);
        monitor.renderables.forEach(n -> {
            if (n instanceof AbstractWidget widget)
                m_142416_(widget);
        });
    }

    public void insPause() {
        instruction("set_pause", new CompoundTag());
    }

    public void insPlaying(boolean playing) {
        var tag = new CompoundTag();
        tag.m_128379_("playing", playing);
        instruction("set_playing", tag);
    }

    public void insVolume(int volume) {
        var tag = new CompoundTag();
        tag.m_128405_("volume", volume);
        instruction("set_volume", tag);
    }

    public void insMute(boolean mute) {
        var tag = new CompoundTag();
        tag.m_128379_("mute", mute);
        instruction("set_mute", tag);
    }

    public void insMonitor(CassetteDeckBlockEntity.MonitorType monitorType) {
        var tag = new CompoundTag();
        tag.m_128359_("name", monitorType.getName());
        instruction("monitor", tag);
    }

    public void insSelectPlaylist(UUID uuid) {
        var tag = new CompoundTag();
        tag.m_128362_("uuid", uuid);
        instruction("select_playlist", tag);
    }

    public void insMusic(UUID uuid) {
        var tag = new CompoundTag();
        tag.m_128362_("music", uuid);
        instruction("set_music", tag);
    }

    public CassetteDeckBlockEntity.MonitorType getRawMonitorType() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return cassetteDeckBlockEntity.getMonitor();
        return CassetteDeckBlockEntity.MonitorType.OFF;
    }

    public ItemStack getCassetteTape() {
        return m_6262_().m_38927_().get(0);
    }

    public boolean isLoading() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isLoading(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isLoading(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoadingMusic();
    }

    public int getVolume() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return getVolume(cassetteDeckBlockEntity);
        return 0;
    }

    public int getVolume(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getVolume();
    }

    public boolean isMute() {
        if (getBlockEntity() instanceof CassetteDeckBlockEntity cassetteDeckBlockEntity)
            return isMute(cassetteDeckBlockEntity);
        return false;
    }

    public boolean isMute(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isMute();
    }

    @Override
    protected ResourceLocation getBackGrandTexture() {
        return BG_TEXTURE;
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        if (monitor != null)
            monitor.depose();
    }

    @Override
    public void m_7400_(List<Path> list) {
        if (monitor != null)
            monitor.onFilesDrop(list);
    }
}
