package dev.felnull.imp.client.renderer.item.hand;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class BoomboxHandRenderer {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void render(PoseStack poseStack, MultiBufferSource multiBufferSource, InteractionHand hand, int packedLight, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, ItemStack stack) {
        //  if (BoomboxItem.getTransferProgress(stack) > 0)
        swingProgress = 0;
        boolean off = hand == InteractionHand.MAIN_HAND;
        HumanoidArm arm = off ? mc.f_91074_.m_5737_() : mc.f_91074_.m_5737_().m_20828_();
        float uns = arm == HumanoidArm.RIGHT ? 1f : -1f;
        float transPr = BoomboxItem.getTransferProgress(stack, partialTicks);

        poseStack.m_85836_();
        OERenderUtils.posePlayerArm(poseStack, arm, swingProgress, equipProgress);
        poseStack.m_85837_(lerpTriple(transPr, -0.85f, -1.5f, 0f) * uns, lerpTriple(transPr, -0.1f, -0.3f, 0.75f), lerpTriple(transPr, 0.32f, 0.6f, 0.5f));
        OERenderUtils.poseRotateAll(poseStack, lerpTriple(transPr, -50f, -50f, -45), lerpTriple(transPr, 0f, 0f, -20) * uns, lerpTriple(transPr, -35f, -35f, 40) * uns);

        OERenderUtils.renderPlayerArm(poseStack, multiBufferSource, arm, packedLight);
        poseStack.m_85849_();

        poseStack.m_85836_();
        OERenderUtils.poseHandItem(poseStack, arm, swingProgress, equipProgress);

        OERenderUtils.poseTrans16(poseStack, Mth.m_14139_(transPr, 0.75f, -0.75) * uns, Mth.m_14139_(transPr, 0.75f, 12.25), Mth.m_14139_(transPr, 0.75f, 7.5));
        OERenderUtils.poseRotateAll(poseStack, Mth.m_14179_(transPr, 8.42f, 0), Mth.m_14179_(transPr, 36.24f, 75) * uns, Mth.m_14179_(transPr, 2.72f, 0) * uns);

        OERenderUtils.renderHandItem(poseStack, multiBufferSource, arm, stack, packedLight);
        poseStack.m_85849_();
    }


    private static float lerpTriple(float par, float v1, float v2, float v3) {
        return par > 0.5f ? Mth.m_14179_(par, v2, v3) : Mth.m_14179_(par, v1, v2);
    }

    public static void pose(HumanoidArm arm, HumanoidModel<? extends LivingEntity> model, ItemStack stack) {
        var marm = arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
        float rv = arm == HumanoidArm.RIGHT ? 1f : -1f;
        marm.f_104203_ = -(float) Math.PI / 2f - 0.1f;
        marm.f_104204_ = 0.5f * rv;
    }

    public static void renderArmWithItem(ItemInHandLayer<? extends LivingEntity, ? extends EntityModel<?>> layer, LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, HumanoidArm arm, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        if (!itemStack.m_41619_()) {
            boolean bl = arm == HumanoidArm.LEFT;
            float rv = arm == HumanoidArm.RIGHT ? 1f : -1f;
            poseStack.m_85836_();
            layer.m_117386_().m_6002_(arm, poseStack);
            OERenderUtils.poseRotateZ(poseStack, -15f * rv);
            OERenderUtils.poseRotateY(poseStack, 180f);
            poseStack.m_85837_(0, 0.2f, 1.2f);
            poseStack.m_85837_(rv / 16.0f, 0.125f, -0.625f);
            Minecraft.m_91087_().f_91063_.f_109055_.m_109322_(livingEntity, itemStack, transformType, bl, poseStack, multiBufferSource, i);
            poseStack.m_85849_();
        }
    }
}
