package dev.felnull.imp.music.resource;

import dev.felnull.otyacraftengine.server.level.TagSerializable;
import net.minecraft.nbt.CompoundTag;

import java.util.Objects;

public class MusicSource implements TagSerializable {
    public static final MusicSource EMPTY = new MusicSource("", "", 0);
    private String loaderType;
    private String identifier;
    private long duration;

    public MusicSource() {

    }

    public MusicSource(String loaderType, String identifier, long duration) {
        this.loaderType = loaderType;
        this.identifier = identifier;
        this.duration = duration;
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128359_("LoaderType", loaderType);
        tag.m_128359_("Identifier", identifier);
        tag.m_128356_("Duration", duration);
    }

    @Override
    public void load(CompoundTag tag) {
        this.loaderType = tag.m_128461_("LoaderType");
        this.identifier = tag.m_128461_("Identifier");
        this.duration = tag.m_128454_("Duration");
    }

    public long getDuration() {
        return duration;
    }

    public String getLoaderType() {
        return loaderType;
    }

    public String getIdentifier() {
        return identifier;
    }

    public boolean isLive() {
        return duration < 0;
    }

    public boolean isEmpty() {
        return this == EMPTY || (loaderType.isEmpty() && identifier.isEmpty());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MusicSource that = (MusicSource) o;
        return duration == that.duration && Objects.equals(loaderType, that.loaderType) && Objects.equals(identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(loaderType, identifier, duration);
    }

    @Override
    public String toString() {
        return "MusicSource{" +
                "loaderType='" + loaderType + '\'' +
                ", identifier='" + identifier + '\'' +
                ", duration=" + duration +
                '}';
    }
}
