package dev.felnull.imp.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.api.IamMusicPlayerAPI;
import dev.felnull.imp.api.music.MusicRingerAccess;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class MusicCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        var literalCommandNode = dispatcher.register(Commands.m_82127_(IamMusicPlayer.MODID).requires(n -> n.m_6761_(2))
                .then(Commands.m_82127_("ringer").executes(n -> ringerInfo(n.getSource(), null))
                        .then(Commands.m_82127_("info").executes(n -> ringerInfo(n.getSource(), null))
                                .then(Commands.m_82129_("dimension", DimensionArgument.m_88805_()).executes(n -> ringerInfo(n.getSource(), DimensionArgument.m_88808_(n, "dimension")))))
                        .then(Commands.m_82127_("list").executes(n -> ringerList(n.getSource(), null))
                                .then(Commands.m_82129_("dimension", DimensionArgument.m_88805_()).executes(n -> ringerList(n.getSource(), DimensionArgument.m_88808_(n, "dimension")))))));

        dispatcher.register(Commands.m_82127_("imp").requires(n -> n.m_6761_(2)).redirect(literalCommandNode));
    }

    private static int ringerInfo(CommandSourceStack src, ServerLevel level) {
        if (level == null) {
            var rngs = IamMusicPlayerAPI.getInstance().getRingers();

            src.m_81354_(Component.m_237110_("commands.imp.ringer.info.all", rngs.size(), rngs.stream().filter(MusicRingerAccess::isPlaying).count()), false);
        } else {
            var name = level.m_46472_().m_135782_();
            var rngs = IamMusicPlayerAPI.getInstance().getRingers(level);

            src.m_81354_(Component.m_237110_("commands.imp.ringer.info", rngs.size(), rngs.stream().filter(MusicRingerAccess::isPlaying).count()), false);
        }
        return 1;
    }

    private static int ringerList(CommandSourceStack src, ServerLevel level) {
        var ringers = level != null ? IamMusicPlayerAPI.getInstance().getRingers(level) : IamMusicPlayerAPI.getInstance().getRingers();

        if (level == null) {
            if (ringers.isEmpty()) {
                src.m_81352_(Component.m_237115_("commands.imp.ringer.list.all.notFound"));
            } else {
                src.m_81354_(Component.m_237115_("commands.imp.ringer.list.all"), false);
                for (MusicRingerAccess ringer : ringers) {
                    src.m_81354_(Component.m_237110_("commands.imp.ringer.list.all.entry" + (ringer.isPlaying() ? ".playing" : ""), ringer.getName(), createPosComponent(ringer.getSpatialPosition(), ringer.getServerLevel()), ringer.getServerLevel().m_46472_().m_135782_()), false);
                }
            }
        } else {
            if (ringers.isEmpty()) {
                src.m_81352_(Component.m_237110_("commands.imp.ringer.list.notFound", level.m_46472_().m_135782_()));
            } else {
                src.m_81354_(Component.m_237110_("commands.imp.ringer.list", level.m_46472_().m_135782_()), false);
                for (MusicRingerAccess ringer : ringers) {
                    src.m_81354_(Component.m_237110_("commands.imp.ringer.list.entry" + (ringer.isPlaying() ? ".playing" : ""), ringer.getName(), createPosComponent(ringer.getSpatialPosition(), ringer.getServerLevel())), false);
                }
            }
        }

        return 1;
    }

    private static Component createPosComponent(Vec3 pos, ServerLevel level) {
        return ComponentUtils.m_130748_(Component.m_237110_("chat.coordinates", pos.f_82479_, pos.f_82480_, pos.f_82481_)).m_130938_((style) -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + level.m_46472_().m_135782_() + " run tp @s " + pos.f_82479_ + " " + pos.f_82480_ + " " + pos.f_82481_)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, Component.m_237115_("chat.coordinates.tooltip"))));
    }
}
