/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CassetteDeckScreen
extends IMPBaseContainerScreen<CassetteDeckMenu> {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/cassette_deck/cassette_deck_base.png");
    public static final ResourceLocation EMPTY_CASSETTE_TAPE_SLOT = new ResourceLocation("iammusicplayer", "textures/gui/container/slot/cassette_tape_slot.png");
    private final Map<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor> monitors = new HashMap<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor>();
    protected CassetteDeckMonitor monitor;

    public CassetteDeckScreen(CassetteDeckMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
        this.f_97726_ = 214;
        this.f_97727_ = 176;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new PowerButton(this, this.f_97735_ + 185, this.f_97736_ + 79, 12, 12, 214, 0, BG_TEXTURE, this.bgTextureWidth, this.bgTextureHeight));
        this.changeScreenMonitor(this.getRawMonitorType());
    }

    protected void m_7286_(PoseStack poseStack, float f, int i, int j) {
        super.m_7286_(poseStack, f, i, j);
        if (this.getCassetteTape().m_41619_()) {
            OERenderUtils.drawTexture((ResourceLocation)EMPTY_CASSETTE_TAPE_SLOT, (PoseStack)poseStack, (float)(this.f_97735_ + 183), (float)(this.f_97736_ + 99), (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f);
        }
        if (this.monitor != null) {
            this.monitor.render(poseStack, f, i, j);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.monitor != null) {
            if (this.getRawMonitorType() != this.monitor.getType()) {
                this.changeScreenMonitor(this.getRawMonitorType());
            }
            this.monitor.tick();
        }
    }

    public long getPosition() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.getPosition(cassetteDeckBlockEntity);
        }
        return 0L;
    }

    public long getPosition(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getPosition();
    }

    public boolean isPlaying() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.isPlaying(cassetteDeckBlockEntity);
        }
        return false;
    }

    public boolean isPlaying(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isPlaying();
    }

    public void insPositionAndRestart(long position) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("position", position);
        this.instruction("restat_and_set_position", tag);
    }

    public void insLoop(boolean loop) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("loop", loop);
        this.instruction("set_loop", tag);
    }

    public boolean isLoop() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.isLoop(cassetteDeckBlockEntity);
        }
        return false;
    }

    public boolean isLoop(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoop();
    }

    private void changeScreenMonitor(CassetteDeckBlockEntity.MonitorType type) {
        if (this.monitor != null) {
            this.monitor.renderables.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.monitor.depose();
        }
        if (!this.monitors.containsKey((Object)type)) {
            this.monitors.put(type, CassetteDeckMonitor.createdCassetteDeckMonitor(type, this));
        }
        this.monitor = this.monitors.get((Object)type);
        this.monitor.init(this.f_97735_, this.f_97736_);
        this.monitor.renderables.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void insPause() {
        this.instruction("set_pause", new CompoundTag());
    }

    public void insPlaying(boolean playing) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("playing", playing);
        this.instruction("set_playing", tag);
    }

    public void insVolume(int volume) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("volume", volume);
        this.instruction("set_volume", tag);
    }

    public void insMute(boolean mute) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("mute", mute);
        this.instruction("set_mute", tag);
    }

    public void insMonitor(CassetteDeckBlockEntity.MonitorType monitorType) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", monitorType.getName());
        this.instruction("monitor", tag);
    }

    public void insSelectPlaylist(UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", uuid);
        this.instruction("select_playlist", tag);
    }

    public void insMusic(UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("music", uuid);
        this.instruction("set_music", tag);
    }

    public CassetteDeckBlockEntity.MonitorType getRawMonitorType() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return cassetteDeckBlockEntity.getMonitor();
        }
        return CassetteDeckBlockEntity.MonitorType.OFF;
    }

    public ItemStack getCassetteTape() {
        return (ItemStack)((CassetteDeckMenu)this.m_6262_()).m_38927_().get(0);
    }

    public boolean isLoading() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.isLoading(cassetteDeckBlockEntity);
        }
        return false;
    }

    public boolean isLoading(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isLoadingMusic();
    }

    public int getVolume() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.getVolume(cassetteDeckBlockEntity);
        }
        return 0;
    }

    public int getVolume(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.getVolume();
    }

    public boolean isMute() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CassetteDeckBlockEntity) {
            CassetteDeckBlockEntity cassetteDeckBlockEntity = (CassetteDeckBlockEntity)blockEntity;
            return this.isMute(cassetteDeckBlockEntity);
        }
        return false;
    }

    public boolean isMute(CassetteDeckBlockEntity cassetteDeckBlockEntity) {
        return cassetteDeckBlockEntity.isMute();
    }

    protected ResourceLocation getBackGrandTexture() {
        return BG_TEXTURE;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.monitor != null) {
            this.monitor.depose();
        }
    }

    public void m_7400_(List<Path> list) {
        if (this.monitor != null) {
            this.monitor.onFilesDrop(list);
        }
    }
}

