/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.include.dev.felnull.fnjl.concurrent.InvokeExecutor;
import dev.felnull.imp.music.SpatialType;
import java.util.concurrent.CompletableFuture;
import org.lwjgl.openal.AL10;

public class MusicUtils {
    public static void checkALError() {
        String error = null;
        int e = AL10.alGetError();
        switch (e) {
            case 40961: {
                error = "Invalid name parameter";
                break;
            }
            case 40962: {
                error = "Invalid parameter";
                break;
            }
            case 40963: {
                error = "Invalid enum parameter value";
                break;
            }
            case 40964: {
                error = "Illegal call";
                break;
            }
            case 40965: {
                error = "Unable to allocate memory";
            }
        }
        if (e != 0) {
            error = "Unknown error";
        }
        if (error != null) {
            MusicEngine.getInstance().getLogger().error("OpenAL Error: {}", (Object)error);
        }
    }

    public static boolean isOnMusicTick() {
        return RenderSystem.m_69586_();
    }

    public static void assertOnMusicTick() {
        if (!MusicUtils.isOnMusicTick()) {
            throw new RuntimeException("Call from wrong thread");
        }
    }

    public static void runOnMusicTick(Runnable runnable) {
        if (MusicUtils.isOnMusicTick()) {
            runnable.run();
        } else {
            CompletableFuture.runAsync(runnable, MusicEngine.getInstance().getMusicTickExecutor()).join();
        }
    }

    public static void runInvokeTasks(InvokeExecutor executor, String name) {
        executor.runTasks(100);
        if (executor.getTaskCount() != 0) {
            MusicEngine.getInstance().getLogger().warn("A lot of music processing tasks are running,Execute separately to reduce the load - Remaining " + name + " Tasks:" + executor.getTaskCount());
        }
    }

    public static boolean isSpatial(SpatialType spatialType) {
        if (spatialType == SpatialType.ENTRUST) {
            return IamMusicPlayer.getConfig().spatial;
        }
        return spatialType == SpatialType.ENABLE;
    }
}

