/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.org.jsoup.nodes;

import dev.felnull.imp.include.org.jsoup.Jsoup;
import dev.felnull.imp.include.org.jsoup.nodes.Document;
import dev.felnull.imp.include.org.jsoup.nodes.Element;
import dev.felnull.imp.include.org.jsoup.nodes.LeafNode;
import dev.felnull.imp.include.org.jsoup.nodes.NodeUtils;
import dev.felnull.imp.include.org.jsoup.nodes.XmlDeclaration;
import dev.felnull.imp.include.org.jsoup.parser.Parser;
import java.io.IOException;

public class Comment
extends LeafNode {
    private static final String COMMENT_KEY = "comment";

    public Comment(String data) {
        this.value = data;
    }

    public Comment(String data, String baseUri) {
        this(data);
    }

    @Override
    public String nodeName() {
        return "#comment";
    }

    public String getData() {
        return this.coreValue();
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (out.prettyPrint()) {
            this.indent(accum, depth, out);
        }
        accum.append("<!--").append(this.getData()).append("-->");
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public boolean isXmlDeclaration() {
        String data = this.getData();
        return data.length() > 1 && (data.startsWith("!") || data.startsWith("?"));
    }

    public XmlDeclaration asXmlDeclaration() {
        String data = this.getData();
        Document doc = Jsoup.parse("<" + data.substring(1, data.length() - 1) + ">", this.baseUri(), Parser.xmlParser());
        XmlDeclaration decl = null;
        if (doc.children().size() > 0) {
            Element el = doc.child(0);
            decl = new XmlDeclaration(NodeUtils.parser(doc).settings().normalizeTag(el.tagName()), data.startsWith("!"));
            decl.attributes().addAll(el.attributes());
        }
        return decl;
    }
}

