/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.felnull.imp.api.IamMusicPlayerAPI;
import dev.felnull.imp.api.MusicRingerAccess;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class MusicCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode literalCommandNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"iammusicplayer").requires(n -> n.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ringer").executes(n -> MusicCommand.ringerInfo((CommandSourceStack)n.getSource(), null))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(n -> MusicCommand.ringerInfo((CommandSourceStack)n.getSource(), null))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(n -> MusicCommand.ringerInfo((CommandSourceStack)n.getSource(), DimensionArgument.m_88808_((CommandContext)n, (String)"dimension")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(n -> MusicCommand.ringerList((CommandSourceStack)n.getSource(), null))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(n -> MusicCommand.ringerList((CommandSourceStack)n.getSource(), DimensionArgument.m_88808_((CommandContext)n, (String)"dimension")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"imp").requires(n -> n.m_6761_(2))).redirect((CommandNode)literalCommandNode));
    }

    private static int ringerInfo(CommandSourceStack src, ServerLevel level) {
        if (level == null) {
            Collection<MusicRingerAccess> rngs = IamMusicPlayerAPI.getInstance().getRingers();
            src.m_81354_((Component)Component.m_237110_((String)"commands.imp.ringer.info.all", (Object[])new Object[]{rngs.size(), rngs.stream().filter(MusicRingerAccess::isPlaying).count()}), false);
        } else {
            ResourceLocation name = level.m_46472_().m_135782_();
            Collection<MusicRingerAccess> rngs = IamMusicPlayerAPI.getInstance().getRingers(level);
            src.m_81354_((Component)Component.m_237110_((String)"commands.imp.ringer.info", (Object[])new Object[]{rngs.size(), rngs.stream().filter(MusicRingerAccess::isPlaying).count()}), false);
        }
        return 1;
    }

    private static int ringerList(CommandSourceStack src, ServerLevel level) {
        Collection<MusicRingerAccess> ringers;
        Collection<MusicRingerAccess> collection = ringers = level != null ? IamMusicPlayerAPI.getInstance().getRingers(level) : IamMusicPlayerAPI.getInstance().getRingers();
        if (level == null) {
            if (ringers.isEmpty()) {
                src.m_81352_((Component)Component.m_237115_((String)"commands.imp.ringer.list.all.notFound"));
            } else {
                src.m_81354_((Component)Component.m_237115_((String)"commands.imp.ringer.list.all"), false);
                for (MusicRingerAccess ringer : ringers) {
                    src.m_81354_((Component)Component.m_237110_((String)("commands.imp.ringer.list.all.entry" + (ringer.isPlaying() ? ".playing" : "")), (Object[])new Object[]{ringer.getName(), MusicCommand.createPosComponent(ringer.getSpatialPosition(), ringer.getServerLevel()), ringer.getServerLevel().m_46472_().m_135782_()}), false);
                }
            }
        } else if (ringers.isEmpty()) {
            src.m_81352_((Component)Component.m_237110_((String)"commands.imp.ringer.list.notFound", (Object[])new Object[]{level.m_46472_().m_135782_()}));
        } else {
            src.m_81354_((Component)Component.m_237110_((String)"commands.imp.ringer.list", (Object[])new Object[]{level.m_46472_().m_135782_()}), false);
            for (MusicRingerAccess ringer : ringers) {
                src.m_81354_((Component)Component.m_237110_((String)("commands.imp.ringer.list.entry" + (ringer.isPlaying() ? ".playing" : "")), (Object[])new Object[]{ringer.getName(), MusicCommand.createPosComponent(ringer.getSpatialPosition(), ringer.getServerLevel())}), false);
            }
        }
        return 1;
    }

    private static Component createPosComponent(Vec3 pos, ServerLevel level) {
        return ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{pos.f_82479_, pos.f_82480_, pos.f_82481_})).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + level.m_46472_().m_135782_() + " run tp @s " + pos.f_82479_ + " " + pos.f_82480_ + " " + pos.f_82481_)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
    }
}

