package dev.felnull.imp.block;

import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class BoomboxData {
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<>();
    private final DataAccess access;
    private MonitorType monitorType = MonitorType.OFF;
    private MonitorType lastMonitorType = MonitorType.OFF;
    private boolean handleRaising = true;
    private boolean lidOpen;
    private int handleRaisedProgressOld = getHandleRaisedMax();
    private int handleRaisedProgress = getHandleRaisedMax();
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int parabolicAntennaProgressOld;
    private int parabolicAntennaProgress;
    private int antennaProgressOld;
    private int antennaProgress;
    private ItemStack oldCassetteTape = ItemStack.f_41583_;
    private boolean oldCassetteTapeFlg;
    private boolean changeCassetteTape;
    private boolean playing;
    private int volume = 150;
    private boolean loop;
    private boolean mute;
    private long musicPosition;
    private boolean loadingMusic;
    private String radioUrl = "";
    private MusicSource radioSource = MusicSource.EMPTY;
    private ImageInfo radioImage = ImageInfo.EMPTY;
    private String radioName = "";
    private String radioAuthor = "";
    private Music selectedMusic;
    private ContinuousType continuousType = ContinuousType.NONE;
    private boolean radioStartFlg;
    private boolean noChangeCassetteTape;

    public BoomboxData(CompoundTag boomboxTag, @NotNull BoomboxData.DataAccess access) {
        this.access = access;
        if (boomboxTag != null) this.load(boomboxTag.m_128469_("BoomBoxData"), true, true);
    }

    public void tick(Level level) {

        this.handleRaisedProgressOld = this.handleRaisedProgress;
        this.lidOpenProgressOld = this.lidOpenProgress;
        this.antennaProgressOld = this.antennaProgress;
        this.parabolicAntennaProgressOld = this.parabolicAntennaProgress;

        if (this.handleRaising)
            this.handleRaisedProgress = Mth.m_14045_(this.handleRaisedProgress + 1, 0, getHandleRaisedMax());
        else this.handleRaisedProgress = Mth.m_14045_(this.handleRaisedProgress - 1, 0, getHandleRaisedMax());

        if (this.lidOpen) this.lidOpenProgress = Mth.m_14045_(this.lidOpenProgress + 1, 0, getLidOpenProgressMax());
        else this.lidOpenProgress = Mth.m_14045_(this.lidOpenProgress - 1, 0, getLidOpenProgressMax());

        if (isUseAntenna() && isRadioStream()) this.antennaProgress = Mth.m_14045_(this.antennaProgress + 1, 0, 30);
        else this.antennaProgress = Mth.m_14045_(this.antennaProgress - 1, 0, 30);

        if (isPowered() && isUseAntenna() && isAntennaExist() && getAntenna().m_150930_(IMPItems.PARABOLIC_ANTENNA.get()))
            this.parabolicAntennaProgress += 2;


        if (!level.m_5776_()) {
            if (getRinger() != null) loadingMusic = getRinger().isRingerWait();

            if (isPowered() && monitorType == MonitorType.OFF) monitorType = MonitorType.PLAYBACK;

            if (!isPowered() && monitorType != MonitorType.OFF) monitorType = MonitorType.OFF;

            if (monitorType != lastMonitorType) {
                lastMonitorType = monitorType;
                setMusicPosition(0);
                setPlaying(false);
            }

            if (!canPlay()) {
                setMusicPosition(0);
                setPlaying(false);
            }

            if (!isRadioRemote()) {
                playerSelectPlaylists.clear();
                setSelectedMusic(null);
                setContinuousType(ContinuousType.NONE);
            }

            if (radioStartFlg) {
                setRadioStartFlg(false);
                setPlaying(true);
            }

            if (monitorType == MonitorType.REMOTE_PLAYBACK && getSelectedMusic() == null)
                monitorType = MonitorType.REMOTE_PLAYBACK_SELECT;

            if (monitorType == MonitorType.RADIO && getRadioSource().isEmpty()) monitorType = MonitorType.RADIO_SELECT;

            if ((isRadio() && !isAntennaExist()) || (isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) || (isRadioStream() && IMPItemUtil.isRemotePlayBackAntenna(getAntenna())))

                if ((isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) || (isRadioStream() && !IMPItemUtil.isRadioAntenna(getAntenna()))) {
                    monitorType = MonitorType.PLAYBACK;
                }

            if (!isRadioStream()) {
                setRadioImage(ImageInfo.EMPTY);
                setRadioSource(MusicSource.EMPTY);
                setRadioAuthor("");
                setRadioName("");
                setRadioUrl("");
            }

            if (monitorType != MonitorType.RADIO_SELECT) setRadioUrl("");

            if (this.changeCassetteTape) {
                if (!isLidOpen()) startLidOpen(true, level);

                if (getLidOpenProgress() >= getLidOpenProgressMax()) {
                    changeCassetteTape = false;
                    startLidOpen(false, level);
                }
            }
        }
    }

    public boolean canPlay() {
        boolean canPlayFlg = monitorType == MonitorType.PLAYBACK && isMusicCassetteTapeExist();
        boolean canPlayFlg2 = monitorType == MonitorType.RADIO && !getRadioSource().isEmpty();
        boolean canPlayFlg3 = monitorType == MonitorType.REMOTE_PLAYBACK;
        return canPlayFlg || canPlayFlg2 || canPlayFlg3;
    }

    public CompoundTag onInstruction(ServerPlayer player, String name, CompoundTag data) {
        if ("buttons_press".equals(name)) {
            ButtonType type = ButtonType.getByName(data.m_128461_("Type"));
            switch (type) {
                case POWER -> setPower(!isPowered());
                case LOOP -> setLoop(!isLoop());
                case VOL_DOWN -> {
                    if (isPowered()) setVolume(Mth.m_14045_(volume - 10, 0, 300));
                }
                case VOL_UP -> {
                    if (isPowered()) setVolume(Mth.m_14045_(volume + 10, 0, 300));
                    setMute(false);
                }
                case VOL_MUTE -> setMute(!isMute());
                case VOL_MAX -> {
                    if (isPowered()) setVolume(300);
                    setMute(false);
                }
                case RADIO -> {
                    if (isRadio()) {
                        setMonitorType(MonitorType.PLAYBACK);
                    } else {
                        setPower(true);
                        setRadioMode();
                    }
                }
                case START -> {
                    if (isMusicCassetteTapeExist() || isRadio()) {
                        setPower(true);
                        setPlaying(true);
                    }
                }
                case STOP -> {
                    if (isPowered()) {
                        setPlaying(false);
                        setMusicPosition(0);
                    }
                }
                case PAUSE -> {
                    if (isPowered()) {
                        setPlaying(false);
                        if (isRadioStream()) setMusicPosition(0);
                    }
                }
            }
            return null;
        } else if ("set_volume".equals(name)) {
            if (isPowered()) setVolume(data.m_128451_("volume"));
            return null;
        } else if ("set_playing".equals(name)) {
            if (isPowered()) {
                boolean pl = data.m_128471_("playing");
                setPlaying(pl);
                if (!pl) setMusicPosition(0);
            }
            return null;
        } else if ("set_pause".equals(name)) {
            if (isPowered()) setPlaying(false);
            return null;
        } else if ("set_loop".equals(name)) {
            if (isPowered()) setLoop(data.m_128471_("loop"));
            return null;
        } else if ("restat_and_set_position".equals(name)) {
            if (isPowered()) setMusicPositionAndRestart(data.m_128454_("position"));
            return null;
        } else if ("set_radio_url".equals(name)) {
            if (isPowered()) setRadioUrl(data.m_128461_("url"));
            return null;
        } else if ("set_monitor".equals(name)) {
            if (isPowered()) {
                var m = MonitorType.getByName(data.m_128461_("name"));
                setMonitorType(m);
                if ((m == MonitorType.RADIO && getRadioSource() != null && !getRadioSource().isEmpty()) || (m == MonitorType.REMOTE_PLAYBACK && getSelectedMusic() != null && !getSelectedMusic().getSource().isEmpty()))
                    setRadioStartFlg(true);
            }
            return null;
        } else if ("set_radio_source".equals(name)) {
            if (isPowered())
                setRadioSource(TagSerializable.loadSavedTag(data.m_128469_("source"), new MusicSource()));
            return null;
        } else if ("set_radio_image".equals(name)) {
            if (isPowered()) setRadioImage(TagSerializable.loadSavedTag(data.m_128469_("image"), new ImageInfo()));
            return null;
        } else if ("set_radio_name".equals(name)) {
            if (isPowered()) setRadioName(data.m_128461_("name"));
            return null;
        } else if ("set_radio_author".equals(name)) {
            if (isPowered()) setRadioAuthor(data.m_128461_("author"));
            return null;
        } else if ("set_selected_play_list".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                if (data.m_128441_("pl")) {
                    var uuid = data.m_128342_("pl");
                    var pl = MusicManager.getInstance().getSaveData(player.f_8924_).getPlayLists().get(uuid);
                    if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly())
                        setSelectedPlayList(player, uuid);
                } else {
                    setSelectedPlayList(player, null);
                }
            }
            return null;
        } else if ("set_selected_music".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                if (data.m_128441_("m")) {
                    var uuid = data.m_128342_("m");
                    var m = MusicManager.getInstance().getSaveData(player.f_8924_).getMusics().get(uuid);
                    if (m != null) {
                        var pl = MusicManager.getInstance().getPlaylistByMusic(player.f_8924_, m.getUuid());
                        if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly()) {
                            setSelectedMusic(m);
                        }
                    }
                } else {
                    setSelectedMusic(null);
                }
            }
            return null;
        } else if ("set_continuous_type".equals(name)) {
            if (isPowered() && isRadioRemote()) {
                setContinuousType(ContinuousType.getByName(data.m_128461_("type")));
            }
            return null;
        }
        return null;
    }

    public void onCassetteTapeChange(ItemStack newItem, ItemStack oldItem) {
        if (!oldCassetteTapeFlg) this.oldCassetteTape = oldItem.m_41777_();
        oldCassetteTapeFlg = false;

        if (!isRadio()) {
            setMusicPosition(0);
            setPlaying(false);
        }
        if (!(newItem.m_41619_() && isLidOpen())) this.changeCassetteTape = true;
        update();
    }

    public void setOldCassetteTape(ItemStack oldCassetteTape) {
        this.oldCassetteTape = oldCassetteTape;
        this.oldCassetteTapeFlg = true;
        update();
    }

    public CompoundTag save(CompoundTag tag, boolean absolutely, boolean sync) {
        tag.m_128359_("MonitorType", this.monitorType.getName());
        tag.m_128379_("HandleRaising", this.handleRaising);
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128379_("Playing", playing);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("Mute", this.mute);
        tag.m_128356_("RingerPosition", this.musicPosition);
        tag.m_128359_("RadioUrl", this.radioUrl);
        tag.m_128365_("RadioSource", this.radioSource.createSavedTag());
        tag.m_128365_("RadioImage", this.radioImage.createSavedTag());
        tag.m_128359_("RadioName", this.radioName);
        tag.m_128359_("RadioAuthor", this.radioAuthor);
        OENbtUtils.writeUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (this.selectedMusic != null) tag.m_128365_("SelectedMusic", this.selectedMusic.createSavedTag());
        tag.m_128359_("ContinuousType", this.continuousType.getName());
        tag.m_128359_("LastMonitorType", this.lastMonitorType.getName());


        if (absolutely) {
            tag.m_128405_("HandleRaisedProgressOld", this.handleRaisedProgressOld);
            tag.m_128405_("HandleRaisedProgress", this.handleRaisedProgress);
            tag.m_128405_("LidOpenProgressOld", this.lidOpenProgressOld);
            tag.m_128405_("LidOpenProgress", this.lidOpenProgress);
            tag.m_128405_("ParabolicAntennaProgressOld", this.parabolicAntennaProgressOld);
            tag.m_128405_("ParabolicAntennaProgress", this.parabolicAntennaProgress);
            tag.m_128405_("AntennaProgressOld", this.antennaProgressOld);
            tag.m_128405_("AntennaProgress", this.antennaProgress);
            tag.m_128379_("NoChangeCassetteTape", this.noChangeCassetteTape);
        }

        if (absolutely || sync) {
            tag.m_128379_("ChangeCassetteTape", this.changeCassetteTape);
            tag.m_128365_("OldCassetteTape", this.oldCassetteTape.m_41739_(new CompoundTag()));
            tag.m_128379_("OldCassetteTapeFlg", oldCassetteTapeFlg);
            tag.m_128379_("LoadingMusic", this.loadingMusic);
            tag.m_128379_("RadioStartFlg", this.radioStartFlg);
        }

        return tag;
    }

    public void load(CompoundTag tag, boolean absolutely, boolean sync) {
        this.monitorType = MonitorType.getByName(tag.m_128461_("MonitorType"));
        this.handleRaising = tag.m_128471_("HandleRaising");
        this.lidOpen = tag.m_128471_("LidOpen");
        this.playing = tag.m_128471_("Playing");
        if (tag.m_128441_("Volume")) this.volume = tag.m_128451_("Volume");
        this.loop = tag.m_128471_("Loop");
        this.mute = tag.m_128471_("Mute");
        this.musicPosition = tag.m_128454_("RingerPosition");
        this.radioUrl = tag.m_128461_("RadioUrl");
        this.radioSource = TagSerializable.loadSavedTag(tag.m_128469_("RadioSource"), new MusicSource());
        this.radioImage = TagSerializable.loadSavedTag(tag.m_128469_("RadioImage"), new ImageInfo());
        this.radioName = tag.m_128461_("RadioName");
        this.radioAuthor = tag.m_128461_("RadioAuthor");
        OENbtUtils.readUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        this.continuousType = ContinuousType.getByName(tag.m_128461_("ContinuousType"));
        this.lastMonitorType = MonitorType.getByName(tag.m_128461_("LastMonitorType"));

        if (tag.m_128441_("SelectedMusic"))
            this.selectedMusic = TagSerializable.loadSavedTag(tag.m_128469_("SelectedMusic"), new Music());

        if (absolutely) {
            this.handleRaisedProgressOld = tag.m_128451_("HandleRaisedProgressOld");
            this.handleRaisedProgress = tag.m_128451_("HandleRaisedProgress");
            this.lidOpenProgressOld = tag.m_128451_("LidOpenProgressOld");
            this.lidOpenProgress = tag.m_128451_("LidOpenProgress");
            this.parabolicAntennaProgressOld = tag.m_128451_("ParabolicAntennaProgressOld");
            this.parabolicAntennaProgress = tag.m_128451_("ParabolicAntennaProgress");
            this.antennaProgressOld = tag.m_128451_("AntennaProgressOld");
            this.antennaProgress = tag.m_128451_("AntennaProgress");
            this.noChangeCassetteTape = tag.m_128471_("NoChangeCassetteTape");
        }

        if (absolutely || sync) {
            this.changeCassetteTape = tag.m_128471_("ChangeCassetteTape");
            this.oldCassetteTape = ItemStack.m_41712_(tag.m_128469_("OldCassetteTape"));
            this.oldCassetteTapeFlg = tag.m_128471_("OldCassetteTapeFlg");
            this.loadingMusic = tag.m_128471_("LoadingMusic");
            this.radioStartFlg = tag.m_128471_("RadioStartFlg");
        }

        if (!sync) {
            if (this.handleRaising) this.handleRaisedProgress = getHandleRaisedMax();
            if (this.lidOpen) this.lidOpenProgress = getLidOpenProgressMax();
        }
    }

    public void setNoChangeCassetteTape(boolean noChangeCassetteTape) {
        this.noChangeCassetteTape = noChangeCassetteTape;
    }

    public boolean isNoChangeCassetteTape() {
        return noChangeCassetteTape;
    }

    public void setRadioSource(MusicSource radioSource) {
        this.radioSource = radioSource;
        update();
    }

    public void setRadioImage(ImageInfo radioImage) {
        this.radioImage = radioImage;
        update();
    }

    public MusicSource getRadioSource() {
        return radioSource;
    }

    public ImageInfo getRadioImage() {
        return radioImage;
    }

    public void setRadioUrl(String radioUrl) {
        this.radioUrl = radioUrl;
        update();
    }

    public void setRadioName(String radioName) {
        this.radioName = radioName;
        update();
    }

    public void setRadioAuthor(String radioAuthor) {
        this.radioAuthor = radioAuthor;
        update();
    }

    public String getRadioName() {
        return radioName;
    }

    public String getRadioAuthor() {
        return radioAuthor;
    }

    public String getRadioUrl() {
        return radioUrl;
    }

    public boolean isLoadingMusic() {
        return loadingMusic;
    }

    public long getMusicPosition() {
        return musicPosition;
    }

    public void setMusicPosition(long position) {
        this.musicPosition = position;
        if (isMusicCassetteTapeExist() && !isRadioRemote()) {
            var m = getMusicSource();
            if (m != null) {
                var nc = CassetteTapeItem.setTapePercentage(getCassetteTape().m_41777_(), (float) position / (float) m.getDuration());
                if (!ItemStack.m_41728_(nc, getCassetteTape())) {
                    setCassetteTape(nc);
                }
            }
        }
        update();
    }

    public void setCassetteTape(ItemStack stack) {
        access.setCassetteTape(stack);
    }

    public MusicSource getMusicSource() {
        if (isMusicCassetteTapeExist()) {
            var m = CassetteTapeItem.getMusic(getCassetteTape());
            if (m != null) return m.getSource();
        }
        return null;
    }

    public void setMusicPositionAndRestart(long position) {
        setMusicPosition(position);
        if (getRinger() != null) {
            getRinger().ringerRestart();
            update();
        }
    }

    public float getRawVolume() {
        return (float) getVolume() / 300f;
    }

    public void setRadioMode() {
        if (isAntennaExist()) {
            if (IMPItemUtil.isRemotePlayBackAntenna(getAntenna())) {
                setMonitorType(MonitorType.REMOTE_PLAYBACK_SELECT);
            } else {
                setMonitorType(MonitorType.RADIO_SELECT);
            }
        }
        update();
    }

    public boolean isRadio() {
        return isRadioStream() || isRadioRemote();
    }

    public boolean isRadioStream() {
        return monitorType == MonitorType.RADIO_SELECT || monitorType == MonitorType.RADIO;
    }

    public boolean isRadioRemote() {
        return monitorType == MonitorType.REMOTE_PLAYBACK || monitorType == MonitorType.REMOTE_PLAYBACK_SELECT;
    }


    public void setPower(boolean power) {
        access.setPower(power);
    }

    public boolean isChangeCassetteTape() {
        return changeCassetteTape;
    }

    private boolean isMusicCassetteTapeExist() {
        return isCassetteTapeExist() && CassetteTapeItem.getMusic(getCassetteTape()) != null;
    }

    private boolean isCassetteTapeExist() {
        return IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    public boolean isPlaying() {
        return playing;
    }


    public void setPlaying(boolean playing) {
        if (canPlay() || !playing) {
            this.playing = playing;
            update();
        }
    }


    public ItemStack getOldCassetteTape() {
        return oldCassetteTape;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
        update();
    }

    public MonitorType getMonitorType() {
        return monitorType;
    }

    public boolean isUseAntenna() {
        return isRadio();
    }

    public boolean isAntennaExist() {
        return IMPItemUtil.isAntenna(getAntenna());
    }

    @Nullable
    public IMusicRinger getRinger() {
        return access.getRinger();
    }

    public boolean cycleLidOpen(Level level) {
        boolean flg = lidOpenProgress >= getLidOpenProgressMax();
        boolean flg2 = lidOpenProgress <= 0;
        if (!flg && !flg2) return false;
        if (flg) {
            startLidOpen(false, level);
        }
        if (flg2) {
            startLidOpen(true, level);
        }
        return true;
    }

    public void setContinuousType(ContinuousType continuousType) {
        this.continuousType = continuousType;
        update();
    }

    public ContinuousType getContinuousType() {
        return continuousType;
    }

    public void setSelectedMusic(Music selectedMusic) {
        this.selectedMusic = selectedMusic;
        update();
    }

    public Music getSelectedMusic() {
        return selectedMusic;
    }

    @Nullable
    public Music getCassetteTapeMusic() {
        if (IMPItemUtil.isCassetteTape(getCassetteTape())) return CassetteTapeItem.getMusic(getCassetteTape());
        return null;
    }

    public void startLidOpen(boolean open, Level level) {
        setLidOpen(open);
        var pos = getPosition();
        level.m_5594_(null, pos, isLidOpen() ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5F, 0.4F / (level.m_213780_().m_188501_() * 0.4F + 0.8F));
    }

    public boolean isLidOpen() {
        return lidOpen;
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        update();
    }

    public void setSelectedPlayList(@NotNull ServerPlayer player, UUID selectedPlayList) {
        if (selectedPlayList != null) {
            playerSelectPlaylists.put(player.m_36316_().getId(), selectedPlayList);
        } else {
            playerSelectPlaylists.remove(player.m_36316_().getId());
        }
        update();
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull Player player) {
        return playerSelectPlaylists.get(player.m_36316_().getId());
    }

    public ItemStack getCassetteTape() {
        return access.getCassetteTape();
    }

    public ItemStack getAntenna() {
        return access.getAntenna();
    }

    public int getLidOpenProgressMax() {
        return 10;
    }

    public int getHandleRaisedProgress() {
        return handleRaisedProgress;
    }

    public float getHandleRaisedProgress(float partialTicks) {
        return Mth.m_14179_(partialTicks, handleRaisedProgressOld, handleRaisedProgress);
    }

    public int getParabolicAntennaProgress() {
        return parabolicAntennaProgress;
    }

    public float getParabolicAntennaProgress(float partialTicks) {
        return Mth.m_14179_(partialTicks, parabolicAntennaProgressOld, parabolicAntennaProgress);
    }

    public int getLidOpenProgress() {
        return lidOpenProgress;
    }

    public float getLidOpenProgress(float partialTicks) {
        return Mth.m_14179_(partialTicks, lidOpenProgressOld, lidOpenProgress);
    }

    public boolean isLoop() {
        return loop;
    }

    public boolean isMute() {
        return mute;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        update();
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        update();
    }

    public void setVolume(int volume) {
        this.volume = volume;
        update();
    }

    public int getVolume() {
        return volume;
    }

    public int getAntennaProgress() {
        return antennaProgress;
    }

    public float getAntennaProgress(float partialTicks) {
        return Mth.m_14179_(partialTicks, antennaProgressOld, antennaProgress);
    }

    public boolean isHandleRaising() {
        return handleRaising;
    }

    public int getHandleRaisedMax() {
        return 10;
    }

    public boolean cycleRaisedHandle() {
        boolean flg = getHandleRaisedProgress() >= getHandleRaisedMax();
        boolean flg2 = getHandleRaisedProgress() <= 0;
        if (!flg && !flg2) return false;
        if (flg) {
            setHandleRaising(false);
        }
        if (flg2) {
            setHandleRaising(true);
        }
        return true;
    }

    public void setHandleRaising(boolean handleRaising) {
        this.handleRaising = handleRaising;
        update();
    }

    public void setHandleRaisedProgressOld(int handleRaisedProgressOld) {
        this.handleRaisedProgressOld = handleRaisedProgressOld;
    }

    public int getHandleRaisedProgressOld() {
        return handleRaisedProgressOld;
    }

    public void setHandleRaisedProgress(int handleRaisedProgress) {
        this.handleRaisedProgress = handleRaisedProgress;
    }

    public void setAntennaProgressOld(int antennaProgressOld) {
        this.antennaProgressOld = antennaProgressOld;
    }

    public boolean isPowered() {
        return access.isPowered();
    }

    public BlockPos getPosition() {
        return BlockPos.m_274446_(access.getPosition());
    }

    public void update() {
        access.dataUpdate(this);
    }

    public static enum MonitorType {
        OFF("off"), PLAYBACK("playback"), REMOTE_PLAYBACK("remote_playback"), REMOTE_PLAYBACK_SELECT("remote_playback_select"), RADIO("radio"), RADIO_SELECT("radio_select");
        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return MonitorType.OFF;
        }
    }

    public void setRadioStartFlg(boolean radioStartFlg) {
        this.radioStartFlg = radioStartFlg;
        update();
    }

    public static interface DataAccess {
        ItemStack getCassetteTape();

        ItemStack getAntenna();

        boolean isPowered();

        void setPower(boolean power);

        IMusicRinger getRinger();

        Vec3 getPosition();

        void setCassetteTape(ItemStack stack);

        void dataUpdate(BoomboxData data);
    }

    public Buttons getButtons() {
        return new Buttons(isRadio(), isPlaying(), !isPlaying() && getMusicPosition() > 0, isLoop(), isMute(), !isMute() && volume >= 300);
    }

    public static record Buttons(boolean radio, boolean start, boolean pause, boolean loop, boolean volMute,
                                 boolean volMax) {
        public static final Buttons EMPTY = new Buttons(false, false, false, false, false, false);
    }

    public static enum ButtonType {
        NONE("none", n -> false), POWER("power", n -> false), RADIO("radio", n -> n.radio()), START("start", n -> n.start()), PAUSE("pause", n -> n.pause()), STOP("stop", n -> false), LOOP("loop", n -> n.loop()), VOL_DOWN("volDown", n -> false), VOL_UP("volUp", n -> false), VOL_MUTE("volMute", n -> n.volMute()), VOL_MAX("volMax", n -> n.volMax());
        private final String name;
        private final Component component;
        private final Function<Buttons, Boolean> getter;

        private ButtonType(String name, Function<Buttons, Boolean> getter) {
            this.name = name;
            this.component = Component.m_237115_("imp.button.boombox." + name);
            this.getter = getter;
        }

        public String getName() {
            return name;
        }

        public Component getComponent() {
            return component;
        }

        public boolean getState(Buttons buttons) {
            return getter.apply(buttons);
        }

        public static ButtonType getByName(String name) {
            for (ButtonType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return NONE;
        }
    }

    public static enum ContinuousType {
        NONE("none"), ORDER("order"), RANDOM("random");
        private final String name;
        private final Component component;

        private ContinuousType(String name) {
            this.name = name;
            this.component = Component.m_237115_("imp.text.continuous." + name);
        }

        public Component getComponent() {
            return component;
        }

        public String getName() {
            return name;
        }

        public static ContinuousType getByName(String name) {
            for (ContinuousType value : values()) {
                if (value.getName().equals(name)) return value;
            }
            return NONE;
        }
    }
}
