package dev.felnull.imp.blockentity;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CassetteDeckBlockEntity extends IMPBaseEntityBlockEntity implements IMusicRinger {
    private NonNullList<ItemStack> items = NonNullList.m_122780_(1, ItemStack.f_41583_);
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<>();
    private Music music = null;
    private MonitorType monitor = MonitorType.OFF;
    private ItemStack oldCassetteTape = ItemStack.f_41583_;
    private final UUID ringerUUID = UUID.randomUUID();
    private boolean changeCassetteTape;
    private boolean lidOpen;
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int cassetteWriteProgress;
    private int volume = 150;
    private boolean mute;
    private boolean playing;
    private long position;
    private boolean loop;
    private boolean loadingMusic;

    public CassetteDeckBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IMPBlockEntities.CASSETTE_DECK.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, CassetteDeckBlockEntity blockEntity) {

        blockEntity.lidOpenProgressOld = blockEntity.lidOpenProgress;

        if (blockEntity.lidOpen) {
            if (blockEntity.lidOpenProgress < blockEntity.getLidOpenProgressAll())
                blockEntity.lidOpenProgress++;
        } else {
            if (blockEntity.lidOpenProgress > 0)
                blockEntity.lidOpenProgress--;
        }

        if (!level.m_5776_()) {

            if (blockEntity.isPowered()) {
                if (blockEntity.monitor == MonitorType.OFF)
                    blockEntity.setMonitor(MonitorType.MENU);
            } else {
                if (blockEntity.monitor != MonitorType.OFF)
                    blockEntity.setMonitor(MonitorType.OFF);
            }

            if ((blockEntity.getMusic() == null || blockEntity.getCassetteTape().m_41619_() || IMPItemUtil.isAntenna(blockEntity.getCassetteTape())) && blockEntity.monitor == MonitorType.WRITE_EXECUTION)
                blockEntity.setMonitor(MonitorType.WRITE);

            if (blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                if (blockEntity.getCassetteWriteProgress() >= blockEntity.getCassetteWriteProgressAll()) {
                    blockEntity.writeCassetteTape();
                    blockEntity.setMonitor(MonitorType.WRITE);
                    blockEntity.setCassetteWriteProgress(0);
                } else {
                    blockEntity.setCassetteWriteProgress(blockEntity.getCassetteWriteProgress() + 1);
                }
            } else {
                if (blockEntity.getCassetteWriteProgress() != 0)
                    blockEntity.setCassetteWriteProgress(0);
            }

            if (blockEntity.monitor != MonitorType.PLAYBACK || !blockEntity.hasMusicCassetteTape()) {
                blockEntity.setRingerPosition(0);
                if (blockEntity.isPlaying())
                    blockEntity.setPlaying(false);
            }

            if (blockEntity.changeCassetteTape) {
                if (!blockEntity.isLidOpen())
                    blockEntity.startLidOpen(true);

                if (blockEntity.lidOpenProgress >= blockEntity.getLidOpenProgressAll()) {
                    blockEntity.changeCassetteTape = false;
                    blockEntity.startLidOpen(false);
                }
            }
            blockEntity.loadingMusic = blockEntity.isRingerWait();
            blockEntity.ringerTick();
        }

        blockEntity.baseAfterTick();
    }

    private boolean canWriteCassetteTape() {
        return getMusic() != null && !getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    private void writeCassetteTape() {
        if (canWriteCassetteTape()) {
            CassetteTapeItem.setMusic(getCassetteTape(), getMusic());
            m_6596_();
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lidOpen = tag.m_128471_("LidOpen");
        if (this.lidOpen)
            lidOpenProgress = getLidOpenProgressAll();
        this.monitor = MonitorType.getByName(tag.m_128461_("Monitor"));
        OENbtUtils.readUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (tag.m_128441_("Music"))
            this.music = TagSerializable.loadSavedTag(tag.m_128469_("Music"), new Music());
        this.cassetteWriteProgress = tag.m_128451_("CassetteWriteProgress");
        this.volume = tag.m_128451_("Volume");
        this.mute = tag.m_128471_("Mute");
        this.playing = tag.m_128471_("Playing");
        this.position = tag.m_128454_("Position");
        this.loop = tag.m_128471_("Loop");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128359_("Monitor", monitor.getName());
        OENbtUtils.readUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (this.music != null)
            tag.m_128365_("Music", music.createSavedTag());
        tag.m_128405_("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Mute", this.mute);
        tag.m_128379_("Playing", this.playing);
        tag.m_128356_("Position", this.position);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("LoadingMusic", this.loadingMusic);
    }

    @Override
    public void saveToUpdateTag(CompoundTag tag) {
        super.saveToUpdateTag(tag);
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128365_("OldCassetteTape", this.oldCassetteTape.m_41739_(new CompoundTag()));
        tag.m_128379_("ChangeCassetteTape", this.changeCassetteTape);
        tag.m_128359_("Monitor", monitor.getName());

        OENbtUtils.writeUUIDMap(tag, "PlayerSelectPlaylist", playerSelectPlaylists);

        if (this.music != null)
            tag.m_128365_("Music", music.createSavedTag());

        tag.m_128405_("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Mute", this.mute);
        tag.m_128379_("Playing", this.playing);
        tag.m_128356_("Position", this.position);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("LoadingMusic", this.loadingMusic);
    }

    @Override
    public void loadToUpdateTag(CompoundTag tag) {
        super.loadToUpdateTag(tag);
        this.lidOpen = tag.m_128471_("LidOpen");
        this.oldCassetteTape = ItemStack.m_41712_(tag.m_128469_("OldCassetteTape"));
        this.changeCassetteTape = tag.m_128471_("ChangeCassetteTape");
        this.monitor = MonitorType.getByName(tag.m_128461_("Monitor"));

        OENbtUtils.readUUIDMap(tag, "PlayerSelectPlaylist", playerSelectPlaylists);

        if (tag.m_128441_("Music"))
            this.music = TagSerializable.loadSavedTag(tag.m_128469_("Music"), new Music());
        else
            this.music = null;

        this.cassetteWriteProgress = tag.m_128451_("CassetteWriteProgress");
        this.volume = tag.m_128451_("Volume");
        this.mute = tag.m_128471_("Mute");
        this.playing = tag.m_128471_("Playing");
        this.position = tag.m_128454_("Position");
        this.loop = tag.m_128471_("Loop");
        this.loadingMusic = tag.m_128471_("LoadingMusic");
    }

    @Override
    public void m_6836_(int i, ItemStack stack) {
        if (i == 0)
            onCassetteTapeChange(stack, getCassetteTape());
        setItemNoChange(i, stack);
    }

    public void setItemNoChange(int i, ItemStack stack) {
        super.m_6836_(i, stack);
    }

    public boolean isLoadingMusic() {
        return loadingMusic;
    }


    public boolean isLoop() {
        return loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        m_6596_();
    }

    public long getPosition() {
        return position;
    }

    public void setPosition(long position) {
        this.position = position;
        m_6596_();
    }

    public boolean isPlaying() {
        return playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
        m_6596_();
    }

    public boolean isMute() {
        return mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        m_6596_();
    }

    public int getVolume() {
        return volume;
    }

    public void setVolume(int volume) {
        if (this.volume != volume)
            setMute(false);
        this.volume = Mth.m_14045_(volume, 0, 300);
        m_6596_();
    }

    public void setPlayerSelectPlayList(ServerPlayer player, UUID uuid) {
        if (uuid != null)
            this.playerSelectPlaylists.put(player.m_36316_().getId(), uuid);
        else
            this.playerSelectPlaylists.remove(player.m_36316_().getId());
        m_6596_();
    }

    public UUID getPlayerSelectPlayList(Player player) {
        return this.playerSelectPlaylists.get(player.m_36316_().getId());
    }

    public int getCassetteWriteProgress() {
        return cassetteWriteProgress;
    }

    public void setCassetteWriteProgress(int cassetteWriteProgress) {
        this.cassetteWriteProgress = cassetteWriteProgress;
        if (!getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(getCassetteTape())) {
            CassetteTapeItem.setTapePercentage(getCassetteTape(), (float) cassetteWriteProgress / (float) getCassetteWriteProgressAll());
        }
        m_6596_();
    }

    public int getLidOpenProgressAll() {
        return 10;
    }

    public MonitorType getMonitor() {
        return monitor;
    }

    public float getLidOpenProgress(float partialTicks) {
        return Mth.m_14179_(partialTicks, lidOpenProgressOld, lidOpenProgress);
    }

    public void startLidOpen(boolean open) {
        setLidOpen(open);
        f_58857_.m_5594_(null, m_58899_(), isLidOpen() ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5F, 0.4F / (f_58857_.m_213780_().m_188501_() * 0.4F + 0.8F));
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        m_6596_();
    }

    public boolean isLidOpen() {
        return lidOpen;
    }

    public boolean isChangeCassetteTape() {
        return changeCassetteTape;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return items;
    }

    @Override
    protected Component m_6820_() {
        return IMPBlocks.CASSETTE_DECK.get().m_49954_();
    }

    @Override
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new CassetteDeckMenu(i, inventory, m_58899_(), this);
    }

    @Override
    public boolean m_7013_(int i, ItemStack itemStack) {
        if (i == 0)
            return IMPItemUtil.isCassetteTape(itemStack);
        return super.m_7013_(i, itemStack);
    }

    public Music getMusic() {
        return music;
    }

    public ItemStack getCassetteTape() {
        return m_8020_(0);
    }

    public ItemStack getOldCassetteTape() {
        return oldCassetteTape;
    }

    protected void onCassetteTapeChange(ItemStack newItem, ItemStack oldItem) {
        if (monitor == MonitorType.WRITE_EXECUTION)
            setMonitor(MonitorType.WRITE);
        setRingerPosition(0);
        setPlaying(false);

        this.oldCassetteTape = oldItem;
        this.changeCassetteTape = true;
    }

    public void setMusic(Music music) {
        this.music = music;
        m_6596_();
    }

    public int getCassetteWriteProgressAll() {
        return 200;
    }

    public void setMonitor(MonitorType monitor) {
        this.monitor = monitor;
        m_6596_();
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, CompoundTag data) {
        if ("monitor".equals(name)) {
            this.monitor = MonitorType.getByName(data.m_128461_("name"));
            if (this.monitor == MonitorType.WRITE_EXECUTION && canWriteCassetteTape())
                IMPCriteriaTriggers.WRITE_CASSETTE_TAPE.trigger(player, getCassetteTape());
            return null;
        } else if ("select_playlist".equals(name)) {
            if (data.m_128441_("uuid")) {
                var uuid = data.m_128342_("uuid");
                var pl = MusicManager.getInstance().getSaveData(getRingerLevel().m_7654_()).getPlayLists().get(uuid);
                if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly())
                    setPlayerSelectPlayList(player, uuid);
            } else {
                setPlayerSelectPlayList(player, null);
            }
            return null;
        } else if ("set_music".equals(name)) {
            if (data.m_128441_("music")) {
                var mm = MusicManager.getInstance();
                var m = mm.getSaveData(getRingerLevel().m_7654_()).getMusics().get(data.m_128342_("music"));
                if (m != null) {
                    var pl = mm.getPlaylistByMusic(getRingerLevel().m_7654_(), m.getUuid());
                    if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly())
                        setMusic(m);
                }
            }
            return null;
        } else if ("set_volume".equals(name)) {
            if (isPowered())
                setVolume(data.m_128451_("volume"));
        } else if ("set_mute".equals(name)) {
            if (isPowered())
                setMute(data.m_128471_("mute"));
        } else if ("set_playing".equals(name)) {
            if (isPowered()) {
                boolean pl = data.m_128471_("playing");
                setPlaying(pl);
                if (!pl)
                    setRingerPosition(0);
            }
        } else if ("set_pause".equals(name)) {
            if (isPowered())
                setPlaying(false);
        } else if ("restat_and_set_position".equals(name)) {
            if (isPowered())
                setMusicPositionAndRestart(data.m_128454_("position"));
            return null;
        } else if ("set_loop".equals(name)) {
            if (isPowered())
                setLoop(data.m_128471_("loop"));
        }
        return super.onInstruction(player, name, data);
    }

    public void setMusicPositionAndRestart(long position) {
        setRingerPosition(position);
        ringerRestart();
    }

    @Override
    public Component getRingerName() {
        return m_6820_();
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel) f_58857_;
    }

    @Override
    public UUID getRingerUUID() {
        return ringerUUID;
    }

    @Override
    public boolean exists() {
        if (m_58904_() == null || f_58857_ != m_58904_()) return false;
        return m_58899_() != null && f_58857_.m_7702_(m_58899_()) == this;
    }

    @Override
    public boolean isRingerPlaying() {
        return isPlaying();
    }

    @Override
    public void setRingerPlaying(boolean playing) {
        setPlaying(playing);
    }

    private boolean hasCassetteTape() {
        return !getCassetteTape().m_41619_() && IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    private boolean hasMusicCassetteTape() {
        return hasCassetteTape() && CassetteTapeItem.getMusic(getCassetteTape()) != null;
    }

    @Override
    public @Nullable MusicSource getRingerMusicSource() {
        return hasMusicCassetteTape() ? CassetteTapeItem.getMusic(getCassetteTape()).getSource() : null;
    }

    @Override
    public boolean isRingerLoop() {
        return isLoop();
    }

    @Override
    public long getRingerPosition() {
        return getPosition();
    }

    @Override
    public void setRingerPosition(long position) {
        setPosition(position);
        if (hasMusicCassetteTape()) {
            var m = getRingerMusicSource();
            if (m != null) {
                var nc = CassetteTapeItem.setTapePercentage(getCassetteTape().m_41777_(), (float) position / (float) m.getDuration());
                setItemNoChange(0, nc);
            }
        }
        m_6596_();
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
        return IMPMusicTrackers.createFixedTracker(getRingerSpatialPosition(), getRingerVolume(), getRingerRange());
//        return Pair.of(MusicRingManager.FIXED_TRACKER, MusicRingManager.createFixedTracker(getRingerSpatialPosition()));
    }

    @Override
    public @NotNull Vec3 getRingerSpatialPosition() {
        return new Vec3(m_58899_().m_123341_() + 0.5, m_58899_().m_123342_() + 0.5, m_58899_().m_123343_() + 0.5);
    }

    public float getRawVolume() {
        return (float) getVolume() / 300f;
    }

    @Override
    public float getRingerVolume() {
        if (isRingerMute())
            return 0;
        return getRawVolume();
    }

    @Override
    public float getRingerRange() {
        if (isRingerMute())
            return 0;
        return 90f * getRawVolume();
    }

    @Override
    public boolean isRingerStream() {
        return false;
    }

    @Override
    public boolean isRingerMute() {
        return isMute();
    }

    public static enum MonitorType {
        OFF("off"),
        MENU("menu"),
        WRITE("write"),
        PLAYBACK("playback"),
        WRITE_EXECUTION("write_execution");
        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return MonitorType.OFF;
        }
    }
}
