package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class MusicManagerBlockEntity extends IMPBaseEntityBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_(0, ItemStack.f_41583_);
    protected final Map<UUID, CompoundTag> playerData = new HashMap<>();

    public MusicManagerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IMPBlockEntities.MUSIC_MANAGER.get(), blockPos, blockState);
    }

    @Override
    protected Component m_6820_() {
        return IMPBlocks.MUSIC_MANAGER.get().m_49954_();
    }

    @Override
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        return new MusicManagerMenu(i, inventory, m_58899_(), this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MusicManagerBlockEntity blockEntity) {
        if (!level.m_5776_()) {
            blockEntity.playerData.forEach((n, m) -> {
                var monst = m.m_128461_("Monitor");
                if (!monst.isEmpty()) {
                    var type = MonitorType.getByName(monst);
                    if ((blockEntity.isPowered() && type == MonitorType.OFF) || (!blockEntity.isPowered() && type != MonitorType.OFF))
                        m.m_128359_("Monitor", MonitorType.getDefault(blockEntity, n).getName());
                    if (type == MonitorType.OFF) {
                        m.m_128473_("SelectedPlayList");
                        m.m_128473_("SelectedMusic");
                    }
                    var mm = MusicManager.getInstance();
                    if (m.m_128441_("SelectedPlayList") && (mm.getSaveData(level.m_7654_()).getPlayLists().get(m.m_128342_("SelectedPlayList")) == null || !mm.getSaveData(level.m_7654_()).getPlayLists().get(m.m_128342_("SelectedPlayList")).getAuthority().getAuthorityType(n).isMoreReadOnly())) {
                        m.m_128473_("SelectedPlayList");
                        m.m_128473_("SelectedMusic");
                    } else if (m.m_128441_("SelectedMusic") && !mm.getSaveData(level.m_7654_()).getMusics().containsKey(m.m_128342_("SelectedMusic"))) {
                        m.m_128473_("SelectedMusic");
                    }

                    if (m.m_128441_("SelectedPlayer")) {
                        boolean rmFlg = !m.m_128441_("SelectedPlayList");
                        boolean rmFlg2 = false;
                        if (m.m_128441_("SelectedPlayList")) {
                            var pl = mm.getSaveData(level.m_7654_()).getPlayLists().get(m.m_128342_("SelectedPlayList"));
                            if (pl != null) {
                                rmFlg2 = !pl.getAuthority().getPlayersAuthority().containsKey(m.m_128342_("SelectedPlayer"));
                            } else {
                                rmFlg2 = true;
                            }
                        }
                        if (rmFlg || rmFlg2)
                            m.m_128473_("SelectedPlayer");
                    }

                    if (type != null && type.isNeedSelectPlayList() && !m.m_128441_("SelectedPlayList")) {
                        m.m_128359_("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                    if (type != null && type.isNeedSelectMusic() && !m.m_128441_("SelectedMusic")) {
                        m.m_128359_("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                }
            });
            blockEntity.m_6596_();
        }

        blockEntity.baseAfterTick();
    }

    private void updateMonitor(ServerPlayer player, MonitorType newM, MonitorType oldM) {
        var tag = getPlayerData(player);

        boolean keepFlg = (oldM == MonitorType.ADD_MUSIC && newM == MonitorType.SEARCH_MUSIC) || (oldM == MonitorType.SEARCH_MUSIC && newM == MonitorType.ADD_MUSIC);
        boolean keepFlg2 = (oldM == MonitorType.ADD_MUSIC && newM == MonitorType.UPLOAD_MUSIC) || (oldM == MonitorType.UPLOAD_MUSIC && newM == MonitorType.ADD_MUSIC);
        boolean keepFlg3 = oldM != null && newM != null && oldM.isKeepPlayListData() && newM.isKeepPlayListData();
        boolean keepFlg4 = oldM != null && newM != null && oldM.isKeepMusicData() && newM.isKeepMusicData();

        if (!keepFlg && !keepFlg2 && !keepFlg3 && !keepFlg4) {
            tag.m_128473_("Image");
            tag.m_128473_("ImageURL");
            tag.m_128473_("CreateName");
            tag.m_128473_("Publishing");
            tag.m_128473_("InitialAuthority");
            tag.m_128473_("InvitePlayerName");
            tag.m_128473_("InvitePlayers");
            tag.m_128473_("MusicLoaderType");
            tag.m_128473_("MusicSourceName");
            tag.m_128473_("MusicSource");
            tag.m_128473_("MusicAuthor");
            tag.m_128473_("ImportIdentifier");
            tag.m_128473_("ImportPlayListName");
            tag.m_128473_("ImportPlayListAuthor");
            tag.m_128473_("ImportPlayListMusicCount");
        }

        tag.m_128473_("SelectedPlayer");

        tag.m_128473_("MusicSearchName");

        var mm = MusicManager.getInstance();

        var pl = getSelectedPlayList(player);
        if (oldM == MonitorType.DETAIL_PLAY_LIST && newM == MonitorType.EDIT_PLAY_LIST && pl != null) {
            var pls = mm.getSaveData(f_58857_.m_7654_()).getPlayLists().get(pl);
            if (pls != null) {
                setImage(player, pls.getImage());
                setCreateName(player, pls.getName());
                setInitialAuthority(player, pls.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.MEMBER ? "member" : "read_only");
                setPublishing(player, pls.getAuthority().isPublic() ? "public" : "private");
                setInvitePlayers(player, pls.getAuthority().getRawAuthority().entrySet().stream().filter(n -> n.getValue().isInvitation()).map(Map.Entry::getKey).toList());
            }
        }

        var m = getSelectedMusic(player);
        if (oldM == MonitorType.DETAIL_MUSIC && newM == MonitorType.EDIT_MUSIC && m != null) {
            var pls = mm.getSaveData(f_58857_.m_7654_()).getPlayLists().get(pl);
            if (pls != null && pls.getMusicList().contains(m)) {
                var ms = mm.getSaveData(f_58857_.m_7654_()).getMusics().get(m);
                if (ms != null) {
                    setImage(player, ms.getImage());
                    setCreateName(player, ms.getName());
                    setMusicAuthor(player, ms.getAuthor());
                    setMusicSource(player, ms.getSource());
                    setMusicLoaderType(player, ms.getSource().getLoaderType());
                }
            }
        }
        m_6596_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        OENbtUtils.readUUIDTagMap(tag, "PlayerData", playerData);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        OENbtUtils.writeUUIDTagMap(tag, "PlayerData", playerData);
    }

    @Override
    public void saveToUpdateTag(CompoundTag tag) {
        super.saveToUpdateTag(tag);
        OENbtUtils.writeUUIDTagMap(tag, "SyncPlayerData", playerData);
    }

    @Override
    public void loadToUpdateTag(CompoundTag tag) {
        super.loadToUpdateTag(tag);
        OENbtUtils.readUUIDTagMap(tag, "SyncPlayerData", playerData);
    }

    @Nullable
    public UUID getSelectedMusic(@NotNull ServerPlayer player) {
        var tag = getPlayerData(player);
        if (tag.m_128441_("SelectedMusic"))
            return tag.m_128342_("SelectedMusic");
        return null;
    }

    @Nullable
    public UUID getSelectedPlayer(@NotNull ServerPlayer player) {
        var tag = getPlayerData(player);
        if (tag.m_128441_("SelectedPlayer"))
            return tag.m_128342_("SelectedPlayer");
        return null;
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull ServerPlayer player) {
        var tag = getPlayerData(player);
        if (tag.m_128441_("SelectedPlayList"))
            return tag.m_128342_("SelectedPlayList");
        return null;
    }

    public CompoundTag getPlayerData(Player player) {
        var id = player.m_36316_().getId();
        if (!playerData.containsKey(id))
            playerData.put(id, new CompoundTag());
        return playerData.get(id);
    }

    @Nullable
    public UUID getSelectedPlayer(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            return null;

        if (!tag.m_128441_("SelectedPlayer"))
            return null;
        return tag.m_128342_("SelectedPlayer");
    }

    @Nullable
    public UUID getSelectedMusic(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            return null;

        if (!tag.m_128441_("SelectedMusic"))
            return null;
        return tag.m_128342_("SelectedMusic");
    }

    public UUID getSelectedPlayList(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            return null;

        if (!tag.m_128441_("SelectedPlayList"))
            return null;
        return tag.m_128342_("SelectedPlayList");
    }

    public MusicSource getMusicSource(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            return null;

        if (tag.m_128441_("MusicSource"))
            return TagSerializable.loadSavedTag(tag.m_128469_("MusicSource"), new MusicSource());
        return MusicSource.EMPTY;
    }

    public void setMusicSource(ServerPlayer player, MusicSource source) {
        getPlayerData(player).m_128365_("MusicSource", source.createSavedTag());
        m_6596_();
    }

    public int getImportPlayListMusicCount(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128451_("ImportPlayListMusicCount");
    }

    public void setImportPlayListMusicCount(@NotNull ServerPlayer player, int num) {
        getPlayerData(player).m_128405_("ImportPlayListMusicCount", num);
        m_6596_();
    }

    @NotNull
    public String getImportPlayListAuthor(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("ImportPlayListAuthor");
    }

    public void setImportPlayListAuthor(@NotNull ServerPlayer player, @NotNull String name) {
        getPlayerData(player).m_128359_("ImportPlayListAuthor", name);
        m_6596_();
    }

    @NotNull
    public String getImportPlayListName(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("ImportPlayListName");
    }

    public void setImportPlayListName(@NotNull ServerPlayer player, @NotNull String name) {
        getPlayerData(player).m_128359_("ImportPlayListName", name);
        m_6596_();
    }

    @NotNull
    public String getImportIdentifier(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("ImportIdentifier");
    }

    public void setImportIdentifier(@NotNull ServerPlayer player, @NotNull String identifier) {
        getPlayerData(player).m_128359_("ImportIdentifier", identifier);
        m_6596_();
    }

    public String getMusicSourceName(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("MusicSourceName");
    }

    public void setMusicSourceName(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("MusicSourceName", name);
        m_6596_();
    }

    public String getMusicAuthor(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("MusicAuthor");
    }

    public void setMusicAuthor(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("MusicAuthor", name);
        m_6596_();
    }

    public String getMusicSearchName(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("MusicSearchName");
    }

    public void setMusicSearchName(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("MusicSearchName", name);
        m_6596_();
    }

    public String getMusicLoaderType(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("MusicLoaderType");
    }

    public void setMusicLoaderType(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("MusicLoaderType", name);
        m_6596_();
    }

    public void setSelectedPlayer(@NotNull ServerPlayer player, @Nullable UUID selectedPlayer) {
        if (selectedPlayer != null) {
            getPlayerData(player).m_128362_("SelectedPlayer", selectedPlayer);
        } else {
            getPlayerData(player).m_128473_("SelectedPlayer");
        }
        m_6596_();
    }

    public void setSelectedMusic(@NotNull ServerPlayer player, @Nullable UUID selectedMusic) {
        var type = getMonitor(player);
        if (type != null && type.isNeedSelectMusic()) {
            if (getPlayerData(player).m_128441_("SelectedMusic")) {
                var old = getPlayerData(player).m_128342_("SelectedMusic");
                if (selectedMusic == null || !selectedMusic.equals(old))
                    setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedMusic != null) {
            getPlayerData(player).m_128362_("SelectedMusic", selectedMusic);
        } else {
            getPlayerData(player).m_128473_("SelectedMusic");
        }
        m_6596_();
    }

    public void setSelectedPlayList(@NotNull ServerPlayer player, @Nullable UUID selectedPlayList) {
        var type = getMonitor(player);
        if (type != null && type.isNeedSelectPlayList()) {
            if (getPlayerData(player).m_128441_("SelectedPlayList")) {
                var old = getPlayerData(player).m_128342_("SelectedPlayList");
                if (selectedPlayList == null || !selectedPlayList.equals(old))
                    setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedPlayList != null) {
            getPlayerData(player).m_128362_("SelectedPlayList", selectedPlayList);
        } else {
            getPlayerData(player).m_128473_("SelectedPlayList");
        }
        m_6596_();
    }


    public List<UUID> getInvitePlayers(Player player) {
        List<UUID> pls = new ArrayList<>();

        var tag = getPlayerData(player);
        if (tag == null)
            return pls;

        OENbtUtils.readUUIDList(tag, "InvitePlayers", pls);
        return pls;
    }

    public void setInvitePlayers(ServerPlayer player, List<UUID> players) {
        var tag = getPlayerData(player);
        tag.m_128473_("InvitePlayers");
        OENbtUtils.writeUUIDList(tag, "InvitePlayers", players);
        m_6596_();
    }

    public String getInvitePlayerName(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("InvitePlayerName");
    }

    public void setInvitePlayerName(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("InvitePlayerName", name);
        m_6596_();
    }

    public void setImage(ServerPlayer player, ImageInfo image) {
        getPlayerData(player).m_128365_("Image", image.createSavedTag());
        m_6596_();
    }

    public ImageInfo getImage(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        if (tag.m_128469_("Image").m_128456_())
            return ImageInfo.EMPTY;
        return TagSerializable.loadSavedTag(tag.m_128469_("Image"), new ImageInfo());
    }

    public String getInitialAuthority(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("InitialAuthority");
    }

    public void setInitialAuthority(ServerPlayer player, String initialAuthority) {
        getPlayerData(player).m_128359_("InitialAuthority", initialAuthority);
        m_6596_();
    }

    public String getPublishing(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("Publishing");
    }

    public void setPublishing(ServerPlayer player, String publishing) {
        getPlayerData(player).m_128359_("Publishing", publishing);
        m_6596_();
    }

    public String getCreateName(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("CreateName");
    }

    public void setCreateName(ServerPlayer player, String name) {
        getPlayerData(player).m_128359_("CreateName", name);
        m_6596_();
    }

    public void setImageURL(ServerPlayer player, String url) {
        getPlayerData(player).m_128359_("ImageURL", url);
        m_6596_();
    }

    public String getImageURL(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        return tag.m_128461_("ImageURL");
    }


    public MonitorType getMonitor(ServerPlayer player) {
        return MonitorType.getByNameOrDefault(getPlayerData(player).m_128461_("Monitor"), this, player.m_36316_().getId());
    }

    public void setMonitor(ServerPlayer player, MonitorType type) {
        var oldM = MonitorType.getByNameOrDefault(getPlayerData(player).m_128461_("Monitor"), this, player.m_36316_().getId());
        if (oldM != type)
            updateMonitor(player, type, oldM);
        getPlayerData(player).m_128359_("Monitor", type.getName());
        m_6596_();
    }

    public MonitorType getMonitor(Player player) {
        var tag = getPlayerData(player);
        if (tag == null)
            tag = new CompoundTag();

        var name = tag.m_128461_("Monitor");
        return MonitorType.getByNameOrDefault(name, this, player.m_36316_().getId());
    }

    @Override
    public CompoundTag onInstruction(ServerPlayer player, String name, CompoundTag data) {
        if ("set_monitor".equals(name)) {
            var mn = data.m_128461_("type");
            if (!mn.isEmpty())
                setMonitor(player, MonitorType.getByName(mn));
            return null;
        } else if ("add_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                var pl = data.m_128342_("playlist");
                MusicManager.getInstance().addPlayListToPlayer(f_58857_.m_7654_(), pl, player);
            }
            return data;
        } else if ("set_image_url".equals(name)) {
            var url = data.m_128461_("url");
            setImageURL(player, url);
            return null;
        } else if ("set_image".equals(name)) {
            var image = TagSerializable.loadSavedTag(data.m_128469_("image"), new ImageInfo());
            setImage(player, image);
            return null;
        } else if ("set_create_name".equals(name)) {
            var cname = data.m_128461_("name");
            setCreateName(player, cname);
            return null;
        } else if ("set_publishing".equals(name)) {
            var pub = data.m_128461_("publishing");
            setPublishing(player, pub);
            return null;
        } else if ("set_initial_authority".equals(name)) {
            var ina = data.m_128461_("initial_authority");
            setInitialAuthority(player, ina);
            return null;
        } else if ("set_invite_player_name".equals(name)) {
            var pname = data.m_128461_("name");
            setInvitePlayerName(player, pname);
            return null;
        } else if ("set_invite_players".equals(name)) {
            List<UUID> pls = new ArrayList<>();
            OENbtUtils.readUUIDList(data, "players", pls);
            setInvitePlayers(player, pls);
            return null;
        } else if ("set_selected_playlist".equals(name)) {
            if (data.m_128441_("playlist")) {
                var id = data.m_128342_("playlist");
                setSelectedPlayList(player, id);
            } else {
                setSelectedPlayList(player, null);
            }
            return data;
        } else if ("set_music_loader_type".equals(name)) {
            var lname = data.m_128461_("name");
            setMusicLoaderType(player, lname);
            return null;
        } else if ("set_music_source_name".equals(name)) {
            var mname = data.m_128461_("name");
            setMusicSourceName(player, mname);
            return null;
        } else if ("set_music_source".equals(name)) {
            var ms = TagSerializable.loadSavedTag(data.m_128469_("MusicSource"), new MusicSource());
            setMusicSource(player, ms);
            return null;
        } else if ("set_music_search_name".equals(name)) {
            var sname = data.m_128461_("name");
            setMusicSearchName(player, sname);
            return null;
        } else if ("set_music_author".equals(name)) {
            var author = data.m_128461_("author");
            setMusicAuthor(player, author);
            return null;
        } else if ("set_import_identifier".equals(name)) {
            setImportIdentifier(player, data.m_128461_("id"));
            return null;
        } else if ("set_import_playlist_name".equals(name)) {
            setImportPlayListName(player, data.m_128461_("name"));
            return null;
        } else if ("set_import_playlist_author".equals(name)) {
            setImportPlayListAuthor(player, data.m_128461_("author"));
            return null;
        } else if ("set_import_playlist_music_count".equals(name)) {
            setImportPlayListMusicCount(player, data.m_128451_("count"));
            return null;
        } else if ("set_selected_music".equals(name)) {
            if (data.m_128441_("music")) {
                var id = data.m_128342_("music");
                setSelectedMusic(player, id);
            } else {
                setSelectedMusic(player, null);
            }
            return null;
        } else if ("set_selected_player".equals(name)) {
            if (data.m_128441_("player")) {
                var id = data.m_128342_("player");
                setSelectedPlayer(player, id);
            } else {
                setSelectedPlayer(player, null);
            }
            return null;
        }
        return super.onInstruction(player, name, data);
    }

    @Override
    public @NotNull NonNullList<ItemStack> getItems() {
        return items;
    }

    public static enum MonitorType {
        OFF("off", false),
        TEST("test", false),
        PLAY_LIST("play_list", false),
        ADD_PLAY_LIST("add_play_list", false),
        ADD_ONLINE_PLAY_LIST("add_online_play_list", false),
        EDIT_PLAY_LIST("edit_play_list", true),
        DETAIL_PLAY_LIST("detail_play_list", true),
        IMPORT_PLAY_LIST_SELECT("import_play_list_select", false),
        CREATE_PLAY_LIST("create_play_list", false),
        DELETE_PLAY_LIST("delete_play_list", true),
        ADD_MUSIC("add_music", true),
        SEARCH_MUSIC("search_music", true),
        UPLOAD_MUSIC("upload_music", true),
        DETAIL_MUSIC("detail_music", true),
        EDIT_MUSIC("edit_music", true),
        DELETE_MUSIC("delete_music", true),
        IMPORT_YOUTUBE_PLAY_LIST("import_youtube_play_list", false),
        IMPORT_MUSICS_SELECT("import_musics_select", true),
        IMPORT_YOUTUBE_PLAY_LIST_MUSICS("import_youtube_play_list_musics", true),
        AUTHORITY("authority", true);
        private final String name;
        private final boolean needSelectPlayList;

        private MonitorType(String name, boolean needSelectPlayList) {
            this.name = name;
            this.needSelectPlayList = needSelectPlayList;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByNameOrDefault(String name, MusicManagerBlockEntity blockEntity, UUID player) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return getDefault(blockEntity, player);
        }


        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return MonitorType.OFF;
        }

        public boolean isNeedSelectPlayList() {
            return needSelectPlayList;
        }

        public boolean isNeedSelectMusic() {
            return this == DETAIL_MUSIC || this == DELETE_MUSIC || this == EDIT_MUSIC;
        }

        public boolean isKeepPlayListData() {
            return this == CREATE_PLAY_LIST || this == IMPORT_PLAY_LIST_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST;
        }

        public boolean isKeepMusicData() {
            return this == ADD_MUSIC || this == IMPORT_MUSICS_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST_MUSICS;
        }

        public static MonitorType getDefault(MusicManagerBlockEntity blockEntity, UUID player) {
            return blockEntity.isPowered() ? PLAY_LIST : OFF;
        }
    }
}
