package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ImageSetButton extends IMPButton implements IIMPSmartRender {
    private final ImageSetType type;

    public ImageSetButton(int x, int y, ImageSetType type, OnPress onPress, Screen screen) {
        super(x, y, 33, 15, type.getName(), onPress, Tooltip.m_257550_(type.getName()));
        this.type = type;
    }

    public static enum ImageSetType {
        FILE_OPEN("file_open"),
        PLAYER_FACE("player_face"),
        DELETE("delete");
        //        URL("url");
        private final Component name;

        private ImageSetType(String name) {
            this.name = Component.m_237115_("imp.button.imageSet." + name);
        }

        public Component getName() {
            return name;
        }
    }

   /* @Override
    public void renderWidget(PoseStack poseStack, int i, int j, float f) {
        drawSmartButtonBox(poseStack, getX(), getY(), width, height, isHoveredOrFocused());
        if (type == ImageSetType.PLAYER_FACE) {
            OERenderUtils.drawPlayerFace(poseStack, mc.player.getGameProfile().getId(), (float) getX() + ((float) width - 11f) / 2f, (float) getY() + ((float) height - 11f) / 2f, 11);
        } else {
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, (float) getX() + ((float) width - 11f) / 2f, (float) getY() + ((float) height - 11f) / 2f, 73 + (type == ImageSetType.DELETE ? 11 : 0), 19, 11, 11);
        }
        *//*if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, mx, my);*//*
    }*/

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        drawSmartButtonBox(guiGraphics, m_252754_(), m_252907_(), f_93618_, f_93619_, m_198029_());
        if (type == ImageSetType.PLAYER_FACE) {
            OERenderUtils.drawPlayerFace(guiGraphics.m_280168_(), mc.f_91074_.m_36316_().getId(), (float) m_252754_() + ((float) f_93618_ - 11f) / 2f, (float) m_252907_() + ((float) f_93619_ - 11f) / 2f, 11);
        } else {
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.m_280168_(), (float) m_252754_() + ((float) f_93618_ - 11f) / 2f, (float) m_252907_() + ((float) f_93619_ - 11f) / 2f, 73 + (type == ImageSetType.DELETE ? 11 : 0), 19, 11, 11);
        }
    }
}
