package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class PlayBackControlWidget extends AbstractWidget implements IIMPSmartRender {
    private final Supplier<StateType> stateTypeSupplier;
    private final Consumer<StateType> press;

    public PlayBackControlWidget(int x, int y, Supplier<StateType> stateTypeSupplier, Consumer<StateType> press) {
        super(x, y, 10, 10, Component.m_237115_("imp.widget.playBackControl"));
        this.stateTypeSupplier = stateTypeSupplier;
        this.press = press;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }


    /*@Override
    public void renderWidget(PoseStack poseStack, int i, int j, float f) {
        var state = stateTypeSupplier.get();
        int z = isHoveredOrFocused() ? 30 : 0;
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, getX(), getY(), state.ordinal() * 10 + z, 145, 10, 10);
    }*/

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        var state = stateTypeSupplier.get();
        int z = m_198029_() ? 30 : 0;
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.m_280168_(), m_252754_(), m_252907_(), state.ordinal() * 10 + z, 145, 10, 10);
    }

    @Override
    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        press.accept(stateTypeSupplier.get());
    }

    public static enum StateType {
        PLAYING, STOP, PAUSE;
    }
}
