package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class PlaybackProgressBar extends AbstractButton {
    private final Supplier<Float> progressGetter;
    private final Consumer<Float> playbackProgressControl;

    public PlaybackProgressBar(int x, int y, Component component, Supplier<Float> progressGetter, Consumer<Float> playbackProgressControl) {
        super(x, y, 153, 3, component);
        this.progressGetter = progressGetter;
        this.playbackProgressControl = playbackProgressControl;
    }

    @Override
    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        if (m_198029_()) {
            if (e >= m_252907_() && e <= (m_252907_() + m_93694_()) && d >= m_252754_() && d <= (m_252754_() + m_5711_()))
                playbackProgressControl.accept((float) ((d - m_252754_()) / m_5711_()));
        }
    }

    @Override
    public void m_5691_() {
    }

    /*@Override
    public void renderWidget(PoseStack poseStack, int i, int j, float f) {
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, getX(), getY(), 52, 54 + (isHoveredOrFocused() ? 3 : 0), getWidth(), getHeight());
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, getX(), getY(), 52, 48 + (isHoveredOrFocused() ? 3 : 0), (float) getWidth() * progressGetter.get(), getHeight());
    }*/

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.m_280168_(), m_252754_(), m_252907_(), 52, 54 + (m_198029_() ? 3 : 0), m_5711_(), m_93694_());
        OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, guiGraphics.m_280168_(), m_252754_(), m_252907_(), 52, 48 + (m_198029_() ? 3 : 0), (float) m_5711_() * progressGetter.get(), m_93694_());
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, this.m_5646_());
    }
}
