package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PowerButton extends ImageButton {
    private final IMPBaseContainerScreen<?> screen;
    private final ResourceLocation resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int textureWidth;
    private final int textureHeight;

    public PowerButton(IMPBaseContainerScreen<?> screen, int x, int y, int width, int height, int xTexStart, int yTexStart, ResourceLocation resourceLocation, int textureWidth, int textureHeight) {
        super(x, y, width, height, xTexStart, yTexStart, height, resourceLocation, textureWidth, textureHeight, button -> onPower(screen), Component.m_237115_("imp.button.power"));
        this.screen = screen;
        this.f_94223_ = resourceLocation;
        this.f_94224_ = xTexStart;
        this.f_94225_ = yTexStart;
        this.f_94227_ = textureWidth;
        this.f_94228_ = textureHeight;
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        // RenderSystem.setShader(GameRenderer::getPositionTexShader);
        //  RenderSystem.setShaderTexture(0, this.resourceLocation);
        int tx = this.f_94224_;
        int ty = this.f_94225_;

        if (this.m_198029_())
            ty += this.f_93619_;

        if (screen.isPowered())
            tx += this.f_93618_;

        //  RenderSystem.enableDepthTest();
        guiGraphics.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (int) tx, (int) ty, this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
        /*if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, i, j);*/
    }

    private static void onPower(IMPBaseContainerScreen<?> screen) {
        screen.insPower(!screen.isPowered());
    }
}
