package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SmartButton extends IMPButton implements IIMPSmartRender {
    private boolean center = true;
    private ResourceLocation iconTexture;
    private int iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight;
    private boolean hideText;

    public void setCenter(boolean center) {
        this.center = center;
    }

    public SmartButton(int x, int y, int w, int h, Component text, OnPress onPress) {
        super(x, y, w, h, text, onPress);
    }

    public void setHideText(boolean hideText) {
        this.hideText = hideText;
    }

    protected int getYImage(boolean bl) {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (bl) {
            i = 2;
        }

        return i;
    }


    @Override
    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        drawSmartButtonBox(guiGraphics, m_252754_(), m_252907_(), f_93618_, f_93619_, this.getYImage(this.m_198029_()));
        float fx = center ? (float) (f_93618_ - mc.f_91062_.m_92852_(m_6035_())) / 2f : 2;
        float fy = (float) (f_93619_ - 7) / 2f;

        if (iconTexture != null) {
            float itx = hideText ? (f_93618_ - iconWidth) / 2f : 2;
            float ity = (float) (f_93619_ - iconHeight) / 2f;
            fx += itx + iconWidth;
            OERenderUtils.drawTexture(iconTexture, guiGraphics.m_280168_(), m_252754_() + itx, m_252907_() + ity, iconStX, iconStY, iconWidth, iconHeight, textureWidth, textureHeight);
        }

        if (!hideText)
            drawSmartText(guiGraphics, m_6035_(), m_252754_() + fx, m_252907_() + fy);

        /*if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, mx, my);*/
    }

    public void setIcon(ResourceLocation location, int stX, int stY, int w, int h) {
        setIcon(location, stX, stY, w, h, 256, 256);
    }

    public void setIcon(ResourceLocation location, int stX, int stY, int w, int h, int texW, int texH) {
        setCenter(false);
        this.iconTexture = location;
        this.iconStX = stX;
        this.iconStY = stY;
        this.iconWidth = w;
        this.iconHeight = h;
        this.textureWidth = texW;
        this.textureHeight = texH;
    }

}
