package dev.felnull.imp.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.CassetteDeckBlock;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;

import java.util.HashMap;
import java.util.Map;

public class CassetteDeckBlockEntityRenderer extends AbstractBlockEntityRenderer<CassetteDeckBlockEntity> {
    private static final Map<CassetteDeckBlockEntity.MonitorType, CassetteDeckMonitor> monitors = new HashMap<>();
    private static final Minecraft mc = Minecraft.m_91087_();

    protected CassetteDeckBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(CassetteDeckBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        renderCassetteDeck(blockEntity, poseStack, multiBufferSource, i, j, f, multiBufferSource.m_6299_(Sheets.m_110790_()));
    }

    public static void renderCassetteDeck(CassetteDeckBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, VertexConsumer vertexConsumer) {
        var lidM = IMPModels.CASSETTE_DECK_LID.get();

        float lidOpen = blockEntity.getLidOpenProgress(f) / (float) blockEntity.getLidOpenProgressAll();

        poseStack.m_85836_();
        OERenderUtils.poseRotateDirection(poseStack, blockEntity.m_58900_().m_61143_(CassetteDeckBlock.FACING), 1);

        if (lidOpen != 0) {
            poseStack.m_85836_();
            OERenderUtils.poseTrans16(poseStack, 3.7, 2.225, 3f);
            OERenderUtils.poseScaleAll(poseStack, 0.72f);
            mc.m_91291_().m_269128_(blockEntity.isChangeCassetteTape() ? blockEntity.getOldCassetteTape() : blockEntity.getCassetteTape(), ItemDisplayContext.FIXED, i, j, poseStack, multiBufferSource, mc.f_91073_, 0);
            poseStack.m_85849_();
        }

        if (!IamMusicPlayer.getConfig().hideDisplaySprite) {
            poseStack.m_85836_();
            poseStack.m_252880_(1, 0, 0);
            OERenderUtils.poseRotateY(poseStack, 180);
            OERenderUtils.poseTrans16(poseStack, 0.6f, 2.35f, -1.9f);
            var monitor = getMonitor(blockEntity.getMonitor());
            float px16 = 1f / 16f;
            monitor.renderAppearance(blockEntity, poseStack, multiBufferSource, LightTexture.f_173040_, j, f, px16 * 7.8f, px16 * 2.275f);
            poseStack.m_85849_();
        }

        poseStack.m_85836_();
        OERenderUtils.poseTrans16(poseStack, 1.5f, 0.5f, 2f);
        OERenderUtils.poseTrans16(poseStack, 0.125, 0.125, 0.125);
        OERenderUtils.poseRotateX(poseStack, lidOpen * -40f);
        OERenderUtils.poseTrans16(poseStack, -0.125, -0.125, -0.125);
        OERenderUtils.renderModel(poseStack, vertexConsumer, lidM, i, j);
        poseStack.m_85849_();

        poseStack.m_85849_();
    }

    private static CassetteDeckMonitor getMonitor(CassetteDeckBlockEntity.MonitorType type) {
        if (monitors.containsKey(type))
            return monitors.get(type);

        var monitor = CassetteDeckMonitor.createdCassetteDeckMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}
