package dev.felnull.imp.data.advancements;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.advancements.AddMusicTrigger;
import dev.felnull.imp.advancements.ListenToMusicTrigger;
import dev.felnull.imp.advancements.WriteCassetteTapeTrigger;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.advancement.ModInvolvementTrigger;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.AdvancementSubProviderWrapper;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

import java.util.function.Consumer;

public class IMPAdvancements extends AdvancementSubProviderWrapper {
    protected IMPAdvancements(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    @Override
    public void generate(Consumer<Advancement> advancementConsumer) {
        Advancement root = Advancement.Builder.m_138353_()
                .m_138371_(IMPBlocks.BOOMBOX.get(), Component.m_237115_("advancements.iammusicplayer.root.title"), Component.m_237115_("advancements.iammusicplayer.root.description"), new ResourceLocation("iammusicplayer:textures/gui/advancements/backgrounds/imp.png"), FrameType.TASK, false, false, false)
                .m_138386_(IamMusicPlayer.MODID, ModInvolvementTrigger.TriggerInstance.involvedMod(IamMusicPlayer.MODID))
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/root").toString());

        Advancement addMusic = Advancement.Builder.m_138353_().m_138398_(root)
                .m_138371_(IMPBlocks.MUSIC_MANAGER.get(), Component.m_237115_("advancements.iammusicplayer.add_music.title"), Component.m_237115_("advancements.iammusicplayer.add_music.description"), null, FrameType.TASK, true, true, false)
                .m_138386_("add_music", AddMusicTrigger.TriggerInstance.addMusic())
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/add_music").toString());

        Advancement writeCassetteTape = Advancement.Builder.m_138353_().m_138398_(addMusic)
                .m_138371_(IMPBlocks.CASSETTE_DECK.get(), Component.m_237115_("advancements.iammusicplayer.write_cassette_tape.title"), Component.m_237115_("advancements.iammusicplayer.write_cassette_tape.description"), null, FrameType.TASK, true, true, false)
                .m_138386_("write_cassette_tape", WriteCassetteTapeTrigger.TriggerInstance.writeCassetteTape())
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/write_cassette_tape").toString());

        Advancement listenToMusic = Advancement.Builder.m_138353_().m_138398_(writeCassetteTape)
                .m_138371_(IMPBlocks.BOOMBOX.get(), Component.m_237115_("advancements.iammusicplayer.listen_to_music.title"), Component.m_237115_("advancements.iammusicplayer.listen_to_music.description"), null, FrameType.TASK, true, true, false)
                .m_138386_("listen_to_music", ListenToMusicTrigger.TriggerInstance.listen(false, false, false))
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/listen_to_music").toString());

        Advancement listenToRadio = Advancement.Builder.m_138353_().m_138398_(listenToMusic)
                .m_138371_(IMPItems.RADIO_ANTENNA.get(), Component.m_237115_("advancements.iammusicplayer.listen_to_radio.title"), Component.m_237115_("advancements.iammusicplayer.listen_to_radio.description"), null, FrameType.GOAL, true, true, false)
                .m_138386_("listen_to_radio", ListenToMusicTrigger.TriggerInstance.listen(true, false, false))
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/listen_to_radio").toString());

        Advancement listenToRemoteMusic = Advancement.Builder.m_138353_().m_138398_(listenToMusic)
                .m_138371_(IMPItems.PARABOLIC_ANTENNA.get(), Component.m_237115_("advancements.iammusicplayer.listen_to_remote_music.title"), Component.m_237115_("advancements.iammusicplayer.listen_to_remote_music.description"), null, FrameType.GOAL, true, true, false)
                .m_138386_("listen_to_remote_music", ListenToMusicTrigger.TriggerInstance.listen(false, true, false))
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/listen_to_remote_music").toString());

        Advancement listenToKamesuta = Advancement.Builder.m_138353_().m_138398_(listenToRemoteMusic)
                .m_138362_(IMPItemUtil.createKamesutaAntenna(), Component.m_237115_("advancements.iammusicplayer.listen_to_kamesuta.title"), Component.m_237115_("advancements.iammusicplayer.listen_to_kamesuta.description"), null, FrameType.CHALLENGE, true, true, true)
                .m_138386_("listen_to_kamesuta", ListenToMusicTrigger.TriggerInstance.listen(false, false, true))
                .m_138389_(advancementConsumer, new ResourceLocation(IamMusicPlayer.MODID, IamMusicPlayer.MODID + "/listen_to_kamesuta").toString());
    }
}
