package dev.felnull.imp.item;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.integration.PatchouliIntegration;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class ManualItem extends Item {
    public static final ResourceLocation MANUAL_BOOK = new ResourceLocation(IamMusicPlayer.MODID, "manual");
    private static final Component INVALID_ITEM = Component.m_237115_("item.iammusicplayer.invalid_item.desc").m_130940_(ChatFormatting.DARK_RED);
    private static final MutableComponent INVALID_ITEM_PATCHOULI = Component.m_237115_("item.iammusicplayer.invalid_item.patchouli.desc");
    private static final MutableComponent INVALID_ITEM_PATCHOULI_CONFIG = Component.m_237115_("item.iammusicplayer.invalid_item.patchouli.config.desc");

    public ManualItem(Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (PatchouliIntegration.INSTANCE.isEnable()) {
            var item = player.m_21120_(interactionHand);
            if (!level.m_5776_()) {
                PatchouliIntegration.INSTANCE.openBookGUI((ServerPlayer) player, MANUAL_BOOK);
            }
            return InteractionResultHolder.m_19090_(item);
        } else {
            if (level.m_5776_())
                player.m_213846_(PatchouliIntegration.INSTANCE.isConfigEnabled() ? INVALID_ITEM_PATCHOULI : INVALID_ITEM_PATCHOULI_CONFIG);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (!PatchouliIntegration.INSTANCE.isEnable()) {
            list.add(INVALID_ITEM);
            list.add((PatchouliIntegration.INSTANCE.isConfigEnabled() ? INVALID_ITEM_PATCHOULI : INVALID_ITEM_PATCHOULI_CONFIG).m_130940_(ChatFormatting.GRAY));
        }
    }
}
