package dev.felnull.imp.music;

import dev.felnull.imp.api.MusicSpeakerInfoAccess;
import dev.felnull.imp.client.util.MusicUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

/**
 * 音楽が流れるスピーカー情報
 *
 * @param position  スピーカーの場所
 * @param volume    ボリューム
 * @param range     範囲
 * @param fixedInfo 固定情報
 */
public record MusicSpeakerInfo(Vec3 position, float volume, float range,
                               MusicSpeakerFixedInfo fixedInfo) implements MusicSpeakerInfoAccess {
    public MusicSpeakerInfo() {
        this(Vec3.f_82478_, 0, 0, new MusicSpeakerFixedInfo());
    }

    public CompoundTag toTag() {
        var tag = new CompoundTag();

        tag.m_128347_("x", position.f_82479_);
        tag.m_128347_("y", position.f_82480_);
        tag.m_128347_("z", position.f_82481_);

        tag.m_128350_("volume", volume);
        tag.m_128350_("range", range);

        tag.m_128365_("fixed_info", fixedInfo.toTag());

        return tag;
    }

    public static MusicSpeakerInfo loadByTag(CompoundTag tag) {
        var position = new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));

        float volume = tag.m_128457_("volume");
        float range = tag.m_128457_("range");

        var fixedInfo = MusicSpeakerFixedInfo.loadByTag(tag.m_128469_("fixed_info"));

        return new MusicSpeakerInfo(position, volume, range, fixedInfo);
    }

    @Override
    public Vec3 getPosition() {
        return position;
    }

    @Override
    public float getVolume() {
        return volume;
    }

    @Override
    public float getRange() {
        return range;
    }

    @Override
    public int getChannel() {
        return fixedInfo().channel();
    }

    @Override
    public boolean isSpatial() {
        return MusicUtils.isSpatial(fixedInfo.spatialType());
    }
}
