package dev.felnull.imp.util;

import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.item.RadioAntennaItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class IMPItemUtil {
    public static boolean isCassetteTape(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CassetteTapeItem;
    }

    public static boolean isAntenna(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof RadioAntennaItem;
    }

    public static boolean isRemotePlayBackAntenna(ItemStack stack) {
        return isAntenna(stack) && stack.m_150930_(IMPItems.PARABOLIC_ANTENNA.get());
    }

    public static boolean isRadioAntenna(ItemStack stack) {
        return isAntenna(stack) && stack.m_150930_(IMPItems.RADIO_ANTENNA.get());
    }

    public static ItemStack createKamesutaAntenna() {
        var st = new ItemStack(IMPItems.PARABOLIC_ANTENNA.get());
        st.m_41714_(Component.m_237113_("Kamesuta").m_130940_(ChatFormatting.GREEN).m_130948_(Style.f_131099_.m_131155_(false)));
        return st;
    }
}
