package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class MusicManagerBlockEntity extends IMPBaseEntityBlockEntity {
    private class_2371<class_1799> items = class_2371.method_10213(0, class_1799.field_8037);
    protected final Map<UUID, class_2487> playerData = new HashMap<>();
    private class_2487 myData = new class_2487();

    public MusicManagerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(IMPBlockEntitys.MUSIC_MANAGER.get(), blockPos, blockState);
    }

    @Override
    protected class_2561 method_17823() {
        return IMPBlocks.MUSIC_MANAGER.get().method_9518();
    }

    @Override
    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new MusicManagerMenu(i, inventory, this, method_11016());
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, MusicManagerBlockEntity blockEntity) {
        if (!level.method_8608()) {
            blockEntity.playerData.forEach((n, m) -> {
                var monst = m.method_10558("Monitor");
                if (!monst.isEmpty()) {
                    var type = MonitorType.getByName(monst);
                    if ((blockEntity.isPower() && type == MonitorType.OFF) || (!blockEntity.isPower() && type != MonitorType.OFF))
                        m.method_10582("Monitor", MonitorType.getDefault(blockEntity, n).getName());
                    if (type == MonitorType.OFF) {
                        m.method_10551("SelectedPlayList");
                        m.method_10551("SelectedMusic");
                    }
                    var mm = MusicManager.getInstance();
                    if (m.method_10545("SelectedPlayList") && (mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList")) == null || !mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList")).getAuthority().getAuthorityType(n).isMoreReadOnly())) {
                        m.method_10551("SelectedPlayList");
                        m.method_10551("SelectedMusic");
                    } else if (m.method_10545("SelectedMusic") && !mm.getSaveData().getMusics().containsKey(m.method_25926("SelectedMusic"))) {
                        m.method_10551("SelectedMusic");
                    }

                    if (m.method_10545("SelectedPlayer")) {
                        boolean rmFlg = !m.method_10545("SelectedPlayList");
                        boolean rmFlg2 = false;
                        if (m.method_10545("SelectedPlayList")) {
                            var pl = mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList"));
                            if (pl != null) {
                                rmFlg2 = !pl.getAuthority().getPlayersAuthority().containsKey(m.method_25926("SelectedPlayer"));
                            } else {
                                rmFlg2 = true;
                            }
                        }
                        if (rmFlg || rmFlg2)
                            m.method_10551("SelectedPlayer");
                    }

                    if (type != null && type.isNeedSelectPlayList() && !m.method_10545("SelectedPlayList")) {
                        m.method_10582("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                    if (type != null && type.isNeedSelectMusic() && !m.method_10545("SelectedMusic")) {
                        m.method_10582("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                }
            });
            blockEntity.method_5431();
            blockEntity.sync();
        }
    }

    private void updateMonitor(class_3222 player, MonitorType newM, MonitorType oldM) {
        var tag = getPlayerData(player);

        boolean keepFlg = (oldM == MonitorType.ADD_MUSIC && newM == MonitorType.SEARCH_MUSIC) || (oldM == MonitorType.SEARCH_MUSIC && newM == MonitorType.ADD_MUSIC);
        boolean keepFlg2 = (oldM == MonitorType.ADD_MUSIC && newM == MonitorType.UPLOAD_MUSIC) || (oldM == MonitorType.UPLOAD_MUSIC && newM == MonitorType.ADD_MUSIC);
        boolean keepFlg3 = oldM != null && newM != null && oldM.isKeepPlayListData() && newM.isKeepPlayListData();
        boolean keepFlg4 = oldM != null && newM != null && oldM.isKeepMusicData() && newM.isKeepMusicData();

        if (!keepFlg && !keepFlg2 && !keepFlg3 && !keepFlg4) {
            tag.remove("Image");
            tag.remove("ImageURL");
            tag.remove("CreateName");
            tag.remove("Publishing");
            tag.remove("InitialAuthority");
            tag.remove("InvitePlayerName");
            tag.remove("InvitePlayers");
            tag.remove("MusicLoaderType");
            tag.remove("MusicSourceName");
            tag.remove("MusicSource");
            tag.remove("MusicAuthor");
            tag.remove("ImportIdentifier");
            tag.remove("ImportPlayListName");
            tag.remove("ImportPlayListAuthor");
            tag.remove("ImportPlayListMusicCount");
        }

        tag.remove("SelectedPlayer");

        tag.remove("MusicSearchName");

        var mm = MusicManager.getInstance();

        var pl = getSelectedPlayList(player);
        if (oldM == MonitorType.DETAIL_PLAY_LIST && newM == MonitorType.EDIT_PLAY_LIST && pl != null) {
            var pls = mm.getSaveData().getPlayLists().get(pl);
            if (pls != null) {
                setImage(player, pls.getImage());
                setCreateName(player, pls.getName());
                setInitialAuthority(player, pls.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.MEMBER ? "member" : "read_only");
                setPublishing(player, pls.getAuthority().isPublic() ? "public" : "private");
                setInvitePlayers(player, pls.getAuthority().getRawAuthority().entrySet().stream().filter(n -> n.getValue().isInvitation()).map(Map.Entry::getKey).toList());
            }
        }

        var m = getSelectedMusic(player);
        if (oldM == MonitorType.DETAIL_MUSIC && newM == MonitorType.EDIT_MUSIC && m != null) {
            var pls = mm.getSaveData().getPlayLists().get(pl);
            if (pls != null && pls.getMusicList().contains(m)) {
                var ms = mm.getSaveData().getMusics().get(m);
                if (ms != null) {
                    setImage(player, ms.getImage());
                    setCreateName(player, ms.getName());
                    setMusicAuthor(player, ms.getAuthor());
                    setMusicSource(player, ms.getSource());
                    setMusicLoaderType(player, ms.getSource().getLoaderType());
                }
            }
        }
        method_5431();
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        OENbtUtil.readMap(tag, "PlayerData", playerData);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        OENbtUtil.writeMap(tag, "PlayerData", playerData);
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        var pltag = playerData.get(player.method_7334().getId());
        if (pltag != null)
            tag.method_10566("Data", pltag);
        return tag;
    }

    @Override
    public void onSync(class_2487 tag) {
        super.onSync(tag);
        this.myData = tag.method_10562("Data");
    }

    @Nullable
    public UUID getSelectedMusic(@NotNull class_3222 player) {
        var tag = getPlayerData(player);
        if (tag.contains("SelectedMusic"))
            return tag.getUUID("SelectedMusic");
        return null;
    }

    @Nullable
    public UUID getSelectedPlayer(@NotNull class_3222 player) {
        var tag = getPlayerData(player);
        if (tag.contains("SelectedPlayer"))
            return tag.getUUID("SelectedPlayer");
        return null;
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull class_3222 player) {
        var tag = getPlayerData(player);
        if (tag.contains("SelectedPlayList"))
            return tag.getUUID("SelectedPlayList");
        return null;
    }

    public class_2487 getPlayerData(class_3222 player) {
        var id = player.method_7334().getId();
        if (!playerData.containsKey(id))
            playerData.put(id, new class_2487());
        return playerData.get(id);
    }

    @Nullable
    public UUID getMySelectedPlayer() {
        if (!myData.method_10545("SelectedPlayer"))
            return null;
        return myData.method_25926("SelectedPlayer");
    }

    @Nullable
    public UUID getMySelectedMusic() {
        if (!myData.method_10545("SelectedMusic"))
            return null;
        return myData.method_25926("SelectedMusic");
    }

    public UUID getMySelectedPlayList() {
        if (!myData.method_10545("SelectedPlayList"))
            return null;
        return myData.method_25926("SelectedPlayList");
    }

    public MusicSource getMyMusicSource() {
        if (myData.method_10545("MusicSource"))
            return OENbtUtil.readSerializable(myData, "MusicSource", new MusicSource());
        return MusicSource.EMPTY;
    }

    public void setMusicSource(class_3222 player, MusicSource source) {
        OENbtUtil.writeSerializable(getPlayerData(player), "MusicSource", source);
        method_5431();
    }

    public int getMyImportPlayListMusicCount() {
        return myData.method_10550("ImportPlayListMusicCount");
    }

    public void setImportPlayListMusicCount(@NotNull class_3222 player, int num) {
        getPlayerData(player).method_10569("ImportPlayListMusicCount", num);
        method_5431();
    }

    @NotNull
    public String getMyImportPlayListAuthor() {
        return myData.method_10558("ImportPlayListAuthor");
    }

    public void setImportPlayListAuthor(@NotNull class_3222 player, @NotNull String name) {
        getPlayerData(player).method_10582("ImportPlayListAuthor", name);
        method_5431();
    }

    @NotNull
    public String getMyImportPlayListName() {
        return myData.method_10558("ImportPlayListName");
    }

    public void setImportPlayListName(@NotNull class_3222 player, @NotNull String name) {
        getPlayerData(player).method_10582("ImportPlayListName", name);
        method_5431();
    }

    @NotNull
    public String getMyImportIdentifier() {
        return myData.method_10558("ImportIdentifier");
    }

    public void setImportIdentifier(@NotNull class_3222 player, @NotNull String identifier) {
        getPlayerData(player).method_10582("ImportIdentifier", identifier);
        method_5431();
    }

    public String getMyMusicSourceName() {
        return myData.method_10558("MusicSourceName");
    }

    public void setMusicSourceName(class_3222 player, String name) {
        getPlayerData(player).method_10582("MusicSourceName", name);
        method_5431();
    }

    public String getMyMusicAuthor() {
        return myData.method_10558("MusicAuthor");
    }

    public void setMusicAuthor(class_3222 player, String name) {
        getPlayerData(player).method_10582("MusicAuthor", name);
        method_5431();
    }

    public String getMyMusicSearchName() {
        return myData.method_10558("MusicSearchName");
    }

    public void setMusicSearchName(class_3222 player, String name) {
        getPlayerData(player).method_10582("MusicSearchName", name);
        method_5431();
    }

    public String getMyMusicLoaderType() {
        return myData.method_10558("MusicLoaderType");
    }

    public void setMusicLoaderType(class_3222 player, String name) {
        getPlayerData(player).method_10582("MusicLoaderType", name);
        method_5431();
    }

    public void setSelectedPlayer(@NotNull class_3222 player, @Nullable UUID selectedPlayer) {
        if (selectedPlayer != null) {
            getPlayerData(player).method_25927("SelectedPlayer", selectedPlayer);
        } else {
            getPlayerData(player).method_10551("SelectedPlayer");
        }
        method_5431();
    }

    public void setSelectedMusic(@NotNull class_3222 player, @Nullable UUID selectedMusic) {
        var type = getMonitor(player);
        if (type != null && type.isNeedSelectMusic()) {
            if (getPlayerData(player).method_10545("SelectedMusic")) {
                var old = getPlayerData(player).method_25926("SelectedMusic");
                if (selectedMusic == null || !selectedMusic.equals(old))
                    setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedMusic != null) {
            getPlayerData(player).method_25927("SelectedMusic", selectedMusic);
        } else {
            getPlayerData(player).method_10551("SelectedMusic");
        }
        method_5431();
    }

    public void setSelectedPlayList(@NotNull class_3222 player, @Nullable UUID selectedPlayList) {
        var type = getMonitor(player);
        if (type != null && type.isNeedSelectPlayList()) {
            if (getPlayerData(player).method_10545("SelectedPlayList")) {
                var old = getPlayerData(player).method_25926("SelectedPlayList");
                if (selectedPlayList == null || !selectedPlayList.equals(old))
                    setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedPlayList != null) {
            getPlayerData(player).method_25927("SelectedPlayList", selectedPlayList);
        } else {
            getPlayerData(player).method_10551("SelectedPlayList");
        }
        method_5431();
    }


    public List<UUID> getMyInvitePlayers() {
        List<UUID> pls = new ArrayList<>();
        OENbtUtil.readUUIDList(myData, "InvitePlayers", pls);
        return pls;
    }

    public void setInvitePlayers(class_3222 player, List<UUID> players) {
        var tag = getPlayerData(player);
        tag.remove("InvitePlayers");
        OENbtUtil.writeUUIDList(tag, "InvitePlayers", players);
        method_5431();
    }

    public String getMyInvitePlayerName() {
        return myData.method_10558("InvitePlayerName");
    }

    public void setInvitePlayerName(class_3222 player, String name) {
        getPlayerData(player).method_10582("InvitePlayerName", name);
        method_5431();
    }

    public void setImage(class_3222 player, ImageInfo image) {
        OENbtUtil.writeSerializable(getPlayerData(player), "Image", image);
        method_5431();
    }

    public ImageInfo getMyImage() {
        if (myData.method_10562("Image").method_33133())
            return ImageInfo.EMPTY;
        return OENbtUtil.readSerializable(myData, "Image", new ImageInfo());
    }

    public String getMyInitialAuthority() {
        return myData.method_10558("InitialAuthority");
    }

    public void setInitialAuthority(class_3222 player, String initialAuthority) {
        getPlayerData(player).method_10582("InitialAuthority", initialAuthority);
        method_5431();
    }

    public String getMyPublishing() {
        return myData.method_10558("Publishing");
    }

    public void setPublishing(class_3222 player, String publishing) {
        getPlayerData(player).method_10582("Publishing", publishing);
        method_5431();
    }

    public String getMyCreateName() {
        return myData.method_10558("CreateName");
    }

    public void setCreateName(class_3222 player, String name) {
        getPlayerData(player).method_10582("CreateName", name);
        method_5431();
    }

    public void setImageURL(class_3222 player, String url) {
        getPlayerData(player).method_10582("ImageURL", url);
        method_5431();
    }

    public String getMyImageURL() {
        return myData.method_10558("ImageURL");
    }


    public MonitorType getMonitor(class_3222 player) {
        return MonitorType.getByNameOrDefault(getPlayerData(player).method_10558("Monitor"), this, player.method_7334().getId());
    }

    public void setMonitor(class_3222 player, MonitorType type) {
        var oldM = MonitorType.getByNameOrDefault(getPlayerData(player).method_10558("Monitor"), this, player.method_7334().getId());
        if (oldM != type)
            updateMonitor(player, type, oldM);
        getPlayerData(player).method_10582("Monitor", type.getName());
        method_5431();
    }

    public MonitorType getMyMonitor(class_1657 player) {
        var name = myData.method_10558("Monitor");
        return MonitorType.getByNameOrDefault(name, this, player.method_7334().getId());
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        if ("set_monitor".equals(name)) {
            var mn = data.method_10558("type");
            if (!mn.isEmpty())
                setMonitor(player, MonitorType.getByName(mn));
            return null;
        } else if ("add_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                var pl = data.method_25926("playlist");
                MusicManager.getInstance().addPlayListToPlayer(pl, player);
            }
            return data;
        } else if ("set_image_url".equals(name)) {
            var url = data.method_10558("url");
            setImageURL(player, url);
            return null;
        } else if ("set_image".equals(name)) {
            var image = OENbtUtil.readSerializable(data, "image", new ImageInfo());
            setImage(player, image);
            return null;
        } else if ("set_create_name".equals(name)) {
            var cname = data.method_10558("name");
            setCreateName(player, cname);
            return null;
        } else if ("set_publishing".equals(name)) {
            var pub = data.method_10558("publishing");
            setPublishing(player, pub);
            return null;
        } else if ("set_initial_authority".equals(name)) {
            var ina = data.method_10558("initial_authority");
            setInitialAuthority(player, ina);
            return null;
        } else if ("set_invite_player_name".equals(name)) {
            var pname = data.method_10558("name");
            setInvitePlayerName(player, pname);
            return null;
        } else if ("set_invite_players".equals(name)) {
            List<UUID> pls = new ArrayList<>();
            OENbtUtil.readUUIDList(data, "players", pls);
            setInvitePlayers(player, pls);
            return null;
        } else if ("set_selected_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                var id = data.method_25926("playlist");
                setSelectedPlayList(player, id);
            } else {
                setSelectedPlayList(player, null);
            }
            return data;
        } else if ("set_music_loader_type".equals(name)) {
            var lname = data.method_10558("name");
            setMusicLoaderType(player, lname);
            return null;
        } else if ("set_music_source_name".equals(name)) {
            var mname = data.method_10558("name");
            setMusicSourceName(player, mname);
            return null;
        } else if ("set_music_source".equals(name)) {
            var ms = OENbtUtil.readSerializable(data, "MusicSource", new MusicSource());
            setMusicSource(player, ms);
            return null;
        } else if ("set_music_search_name".equals(name)) {
            var sname = data.method_10558("name");
            setMusicSearchName(player, sname);
            return null;
        } else if ("set_music_author".equals(name)) {
            var author = data.method_10558("author");
            setMusicAuthor(player, author);
            return null;
        } else if ("set_import_identifier".equals(name)) {
            setImportIdentifier(player, data.method_10558("id"));
            return null;
        } else if ("set_import_playlist_name".equals(name)) {
            setImportPlayListName(player, data.method_10558("name"));
            return null;
        } else if ("set_import_playlist_author".equals(name)) {
            setImportPlayListAuthor(player, data.method_10558("author"));
            return null;
        } else if ("set_import_playlist_music_count".equals(name)) {
            setImportPlayListMusicCount(player, data.method_10550("count"));
            return null;
        } else if ("set_selected_music".equals(name)) {
            if (data.method_10545("music")) {
                var id = data.method_25926("music");
                setSelectedMusic(player, id);
            } else {
                setSelectedMusic(player, null);
            }
            return null;
        } else if ("set_selected_player".equals(name)) {
            if (data.method_10545("player")) {
                var id = data.method_25926("player");
                setSelectedPlayer(player, id);
            } else {
                setSelectedPlayer(player, null);
            }
            return null;
        }
        return super.onInstruction(player, name, num, data);
    }

    @Override
    public @NotNull class_2371<class_1799> getItems() {
        return items;
    }

    public static enum MonitorType {
        OFF("off", false),
        TEST("test", false),
        PLAY_LIST("play_list", false),
        ADD_PLAY_LIST("add_play_list", false),
        ADD_ONLINE_PLAY_LIST("add_online_play_list", false),
        EDIT_PLAY_LIST("edit_play_list", true),
        DETAIL_PLAY_LIST("detail_play_list", true),
        IMPORT_PLAY_LIST_SELECT("import_play_list_select", false),
        CREATE_PLAY_LIST("create_play_list", false),
        DELETE_PLAY_LIST("delete_play_list", true),
        ADD_MUSIC("add_music", true),
        SEARCH_MUSIC("search_music", true),
        UPLOAD_MUSIC("upload_music", true),
        DETAIL_MUSIC("detail_music", true),
        EDIT_MUSIC("edit_music", true),
        DELETE_MUSIC("delete_music", true),
        IMPORT_YOUTUBE_PLAY_LIST("import_youtube_play_list", false),
        IMPORT_MUSICS_SELECT("import_musics_select", true),
        IMPORT_YOUTUBE_PLAY_LIST_MUSICS("import_youtube_play_list_musics", true),
        AUTHORITY("authority", true);
        private final String name;
        private final boolean needSelectPlayList;

        private MonitorType(String name, boolean needSelectPlayList) {
            this.name = name;
            this.needSelectPlayList = needSelectPlayList;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByNameOrDefault(String name, MusicManagerBlockEntity blockEntity, UUID player) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return getDefault(blockEntity, player);
        }


        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return MonitorType.OFF;
        }

        public boolean isNeedSelectPlayList() {
            return needSelectPlayList;
        }

        public boolean isNeedSelectMusic() {
            return this == DETAIL_MUSIC || this == DELETE_MUSIC || this == EDIT_MUSIC;
        }

        public boolean isKeepPlayListData() {
            return this == CREATE_PLAY_LIST || this == IMPORT_PLAY_LIST_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST;
        }

        public boolean isKeepMusicData() {
            return this == ADD_MUSIC || this == IMPORT_MUSICS_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST_MUSICS;
        }

        public static MonitorType getDefault(MusicManagerBlockEntity blockEntity, UUID player) {
            return blockEntity.isPower() ? PLAY_LIST : OFF;
        }
    }
}
