package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class BoomboxButton extends class_4185 {
    private final BoomboxData.ButtonType type;
    private final Supplier<BoomboxData.Buttons> buttons;
    private final BooleanSupplier downShift;

    public BoomboxButton(int x, int y, BoomboxData.ButtonType type, class_4241 onPress, Supplier<BoomboxData.Buttons> buttons) {
        this(x, y, type, onPress, buttons, () -> false);
    }

    public BoomboxButton(int x, int y, BoomboxData.ButtonType type, class_4241 onPress, Supplier<BoomboxData.Buttons> buttons, BooleanSupplier downShift) {
        super(x, y, 19, 13, type.getComponent(), onPress);
        this.type = type;
        this.buttons = buttons;
        this.downShift = downShift;
    }

    @Override
    public void method_25359(class_4587 poseStack, int i, int j, float f) {
        int r = method_25367() ? 1 : 0;
        if (type.getState(buttons.get()))
            r += 2;
        OERenderUtil.drawTexture(BoomboxScreen.BG_TEXTURE, poseStack, field_22760, field_22761, r * 19, 175, 19, 13);

        float zx = ((float) field_22758 - 9f) / 2f;
        float zy = ((float) field_22759 - 9f) / 2f;
        OERenderUtil.drawTexture(BoomboxScreen.BG_TEXTURE, poseStack, field_22760 + zx, field_22761 + zy, (type.ordinal() - 1) * 9, 188 + (downShift.getAsBoolean() ? 9 : 0), 9, 9);
    }

    public BoomboxData.ButtonType getType() {
        return type;
    }

}
