package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import var;

public class JoinPlayListFixedButtonsList extends PlayListFixedButtonsList {
    public JoinPlayListFixedButtonsList(int x, int y, List<MusicPlayList> list, PressEntry<MusicPlayList> onPressEntry) {
        super(x, y, 368, 168, 6, new class_2588("imp.fixedList.joinPlaylist"), list, onPressEntry);
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, MusicPlayList item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        int k = this.method_25356(this.isHoveredOrFocused(bnum));
        drawSmartButtonBox(poseStack, x, y, getOneButtonWidth(), getOneButtonHeight(), k);

        var img = item.getImage();

        float sx = 1;

        if (!img.isEmpty()) {
            sx += getOneButtonHeight() - 2 + 1;
            PlayImageRenderer.getInstance().draw(img, poseStack, x + 1, y + 1, getOneButtonHeight() - 2);
        }

        drawSmartFixedWidthText(poseStack, new class_2585(item.getName()), x + sx, y + 3, 90);
        drawSmartFixedWidthText(poseStack, new class_2585(MyPlayListFixedButtonsList.dateFormat.format(new Date(item.getCreateDate()))), x + sx, y + 17, 90);

        OERenderUtil.drawPlayerFace(poseStack, item.getAuthority().getOwnerName(), x + sx + 101, y + 2, 9);
        drawSmartFixedWidthText(poseStack, new class_2585(item.getAuthority().getOwnerName()), x + sx + 112, y + 3, 90);
        drawSmartFixedWidthText(poseStack, new class_2588("imp.text.musicCount", item.getMusicList().size()), x + sx + 101, y + 17, 45);
        drawSmartFixedWidthText(poseStack, new class_2588("imp.text.playerCount", item.getPlayerCount()), x + sx + 156, y + 17, 45);

        if (item.getAuthority().getAuthorityType(mc.field_1724.method_7334().getId()).isInvitation()) {
            drawSmartFixedWidthText(poseStack, new class_2588("imp.text.invitation"), x + sx + 204, y + 3, 100, 0xFF0000FF);
        }
    }
}
