package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class PowerButton extends class_344 {
    private final IMPBaseContainerScreen<?> screen;
    private final class_2960 resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int textureWidth;
    private final int textureHeight;

    public PowerButton(IMPBaseContainerScreen<?> screen, int x, int y, int width, int height, int xTexStart, int yTexStart, class_2960 resourceLocation, int textureWidth, int textureHeight) {
        super(x, y, width, height, xTexStart, yTexStart, height, resourceLocation, textureWidth, textureHeight, button -> onPower(screen), new class_2588("imp.button.power"));
        this.screen = screen;
        this.resourceLocation = resourceLocation;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    public void method_25359(class_4587 poseStack, int i, int j, float f) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, this.resourceLocation);
        int tx = this.xTexStart;
        int ty = this.yTexStart;

        if (this.method_25367())
            ty += this.field_22759;

        if (screen.isPower())
            tx += this.field_22758;

        RenderSystem.enableDepthTest();
        method_25290(poseStack, this.field_22760, this.field_22761, (float) tx, (float) ty, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight);
        if (this.method_25367())
            this.method_25352(poseStack, i, j);
    }

    private static void onPower(IMPBaseContainerScreen<?> screen) {
        screen.insPower(!screen.isPower());
    }
}
