package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SearchMusicsFixedButtonsList;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.IMusicLoaderType;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.FlagThread;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import record;
import var;

public class SearchMusicMMMonitor extends MusicManagerMonitor {
    private static final class_2960 SEARCH_MUSIC_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/music_manager/monitor/search_music.png");
    private static final class_2561 SEARCHING_TEXT = new class_2588("imp.text.searching");
    private final List<SearchMusicEntry> searchMusics = new ArrayList<>();
    private SearchMusicsFixedButtonsList searchMusicsFixedButtonsList;
    private class_342 searchNameEditBox;
    private SearchThread searchThread;

    public SearchMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.searchMusicsFixedButtonsList = this.addRenderWidget(new SearchMusicsFixedButtonsList(getStartX() + 2, getStartY() + 25, 366, 172, 4, new class_2588("imp.fixedList.searchMusic"), searchMusics, (fixedButtonsList, searchMusicEntry, i, i1) -> {
            setMusicSourceName(searchMusicEntry.source().getIdentifier());
            getScreen().lastSearch = true;
            insMonitor(MusicManagerBlockEntity.MonitorType.ADD_MUSIC);
        }));

        this.searchNameEditBox = new class_342(IIMPSmartRender.mc.field_1772, getStartX() + 2, getStartY() + 11, 367, 12, new class_2588("imp.editBox.musicSearchName"));
        this.searchNameEditBox.method_1880(300);
        this.searchNameEditBox.method_1852(getMusicSearchName());
        this.searchNameEditBox.method_1863(this::setMusicSearchName);
        addRenderWidget(this.searchNameEditBox);

        startMusicSearch(getMusicSearchName());
    }

    @Override
    public void depose() {
        super.depose();
        stopMusicSearch();
        searchMusics.clear();
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture(SEARCH_MUSIC_TEXTURE, poseStack, getStartX(), getStartY(), 0f, 0f, width, height, width, height);
        if (searchMusics.isEmpty() && !getMusicSearchName().isEmpty() && searchThread != null && searchThread.isAlive())
            drawSmartText(poseStack, SEARCHING_TEXT, getStartX() + 3, getStartY() + 27);
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float) width;
        float onPxH = monitorHeight / (float) height;
        OERenderUtil.renderTextureSprite(SEARCH_MUSIC_TEXTURE, poseStack, multiBufferSource, 0, 0, OERenderUtil.MIN_BREADTH * 3, 0, 0, 0, monitorWidth, monitorHeight, 0, 0, width, height, width, height, i, j);
        renderSmartEditBoxSprite(poseStack, multiBufferSource, 2, 11, OERenderUtil.MIN_BREADTH * 3, 367, 12, i, j, onPxW, onPxH, monitorHeight, getMusicSearchName(blockEntity));

        renderScrollbarSprite(poseStack, multiBufferSource, 359, 25, OERenderUtil.MIN_BREADTH * 3, 172, i, j, onPxW, onPxH, monitorHeight, 0, 6);
    }

    private void startMusicSearch(String name) {
        this.stopMusicSearch();
        this.searchThread = new SearchThread(name);
        this.searchThread.start();
    }

    private void stopMusicSearch() {
        if (this.searchThread != null) {
            this.searchThread.stopped();
            this.searchThread = null;
        }
    }

    public String getMusicSearchName() {
        if (getScreen().getBlockEntity() instanceof MusicManagerBlockEntity blockEntity)
            return getMusicSearchName(blockEntity);
        return "";
    }

    public String getMusicSearchName(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyMusicSearchName();
    }

    private void setMusicSearchName(String name) {
        if (!getMusicSearchName().equals(name))
            startMusicSearch(name);
        getScreen().insMusicSearchName(name);
    }

    private void setMusicSourceName(String name) {
        getScreen().insMusicSourceName(name);
    }

    public IMusicLoaderType getRawMusicLoaderType() {
        return IMPMusicLoaderTypes.getMusicLoaderTypes().get(getMusicLoaderType());
    }

    public String getMusicLoaderType() {
        if (getScreen().getBlockEntity() instanceof MusicManagerBlockEntity blockEntity)
            return getMusicLoaderType(blockEntity);
        return "auto";
    }

    public String getMusicLoaderType(MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyMusicLoaderType().isEmpty() ? "auto" : blockEntity.getMyMusicLoaderType();
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_MUSIC;
    }

    public static record SearchMusicEntry(String name, String artist, MusicSource source, ImageInfo imageInfo) {
    }

    private class SearchThread extends FlagThread {
        private final String name;

        public SearchThread(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            if (isStopped())
                return;
            var lt = getRawMusicLoaderType();
            if (lt == null || !lt.isSearchable())
                return;

            if (isStopped())
                return;

            List<SearchMusicEntry> slst;
            try {
                slst = lt.search(name);
            } catch (InterruptedException e) {
                return;
            }

            if (isStopped())
                return;

            setSearchMusics(slst);
        }

        private synchronized void setSearchMusics(List<SearchMusicEntry> musics) {
            if (musics != null) {
                searchMusics.clear();
                searchMusics.addAll(musics);
            }
        }
    }
}
