package dev.felnull.imp.client.renderer.blockentity;

import dev.felnull.imp.block.MusicManagerBlock;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import var;

public class MusicManagerBlockEntityRenderer extends AbstractBlockEntityRenderer<MusicManagerBlockEntity> {
    private static final Map<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor> monitors = new HashMap<>();
    private static final class_310 mc = class_310.method_1551();
    private static final Random random = new Random();

    protected MusicManagerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public void render(MusicManagerBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        renderMusicManager(blockEntity, poseStack, multiBufferSource, i, j, f);
    }

    public static void renderMusicManager(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f) {
        var vc = multiBufferSource.getBuffer(class_4722.method_24074());

        var acLmp = OEModelUtil.getModel(IMPModels.MUSIC_MANAGER_OFF_ACCESS_LAMP);

        if (blockEntity.isPower() && random.nextBoolean())
            acLmp = OEModelUtil.getModel(IMPModels.MUSIC_MANAGER_ACCESS_LAMP);

        poseStack.method_22903();
        OERenderUtil.poseRotateDirection(poseStack, blockEntity.method_11010().method_11654(MusicManagerBlock.FACING), 1);

        poseStack.method_22903();
        OERenderUtil.renderModel(poseStack, vc, acLmp, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        poseStack.method_22904(1, 0, 0);
        OERenderUtil.poseRotateY(poseStack, 180);
        OERenderUtil.poseTrans16(poseStack, 0.25f, 1.75f, -12.375f);
        var monitor = getMonitor(blockEntity.getMyMonitor(mc.field_1724));
        float px16 = 1f / 16f;
        monitor.renderAppearance(blockEntity, poseStack, multiBufferSource, class_765.field_32767, j, f, px16 * 10.5f, px16 * 6.5f);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static MusicManagerMonitor getMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (monitors.containsKey(type))
            return monitors.get(type);

        var monitor = MusicManagerMonitor.createdMusicMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}
