package dev.felnull.imp.client.renderer.item;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.renderer.blockentity.BoomboxBlockEntityRenderer;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_809;
import var;

public class BoomboxItemRenderer implements BEWLItemRenderer {
    private final BoomboxBlockEntity onEntity = new BoomboxBlockEntity(class_2338.field_10980, IMPBlocks.BOOMBOX.get().method_9564().method_11657(BoomboxBlock.POWERED, true));
    private final BoomboxBlockEntity offEntity = new BoomboxBlockEntity(class_2338.field_10980, IMPBlocks.BOOMBOX.get().method_9564());

    @Override
    public void render(class_1799 itemStack, class_809.class_811 transformType, class_4587 poseStack, class_4597 multiBufferSource, float f, int i, int i1) {
        boolean power = BoomboxItem.isPowerOn(itemStack);
        boolean radio = false;

        var state = power ? onEntity.method_11010() : offEntity.method_11010();
        var model = OEModelUtil.getModel(state);
        var vc = multiBufferSource.getBuffer(class_4722.method_24074());
        OERenderUtil.renderModel(poseStack, vc, model, i, i1);

        float handleRaised = 1;

        if (transformType == class_809.class_811.field_4321 || transformType == class_809.class_811.field_4322 || transformType == class_809.class_811.field_4323 || transformType == class_809.class_811.field_4320) {
            handleRaised = 1f - BoomboxItem.getTransferProgress(itemStack, f);
        }

        BoomboxBlockEntityRenderer.renderBoombox(poseStack, multiBufferSource, state.getValue(BoomboxBlock.FACING), i, i1, f, BoomboxItem.getData(itemStack), handleRaised);
    }
}
