package dev.felnull.imp.music.resource;

import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import java.util.Objects;
import net.minecraft.class_2487;

public class MusicSource implements ITAGSerializable {
    public static final MusicSource EMPTY = new MusicSource("", "", 0);
    private String loaderType;
    private String identifier;
    private long duration;

    public MusicSource() {

    }

    public MusicSource(String loaderType, String identifier, long duration) {
        this.loaderType = loaderType;
        this.identifier = identifier;
        this.duration = duration;
    }

    @Override
    public class_2487 save(class_2487 tag) {
        tag.method_10582("LoaderType", loaderType);
        tag.method_10582("Identifier", identifier);
        tag.method_10544("Duration", duration);
        return tag;
    }

    @Override
    public void load(class_2487 tag) {
        this.loaderType = tag.method_10558("LoaderType");
        this.identifier = tag.method_10558("Identifier");
        this.duration = tag.method_10537("Duration");
    }

    public long getDuration() {
        return duration;
    }

    public String getLoaderType() {
        return loaderType;
    }

    public String getIdentifier() {
        return identifier;
    }

    public boolean isLive() {
        return duration < 0;
    }

    public boolean isEmpty() {
        return this == EMPTY || (loaderType.isEmpty() && identifier.isEmpty());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MusicSource that = (MusicSource) o;
        return duration == that.duration && Objects.equals(loaderType, that.loaderType) && Objects.equals(identifier, that.identifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(loaderType, identifier, duration);
    }

    @Override
    public String toString() {
        return "MusicSource{" +
                "loaderType='" + loaderType + '\'' +
                ", identifier='" + identifier + '\'' +
                ", duration=" + duration +
                '}';
    }
}
