package dev.felnull.imp.blockentity;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.inventory.CassetteDeckMenu;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class CassetteDeckBlockEntity extends IMPBaseEntityBlockEntity implements IMusicRinger {
    private class_2371<class_1799> items = class_2371.method_10213(1, class_1799.field_8037);
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<>();
    private UUID myPlayerSelectPlaylist;
    private Music music = null;
    private MonitorType monitor = MonitorType.OFF;
    private class_1799 oldCassetteTape = class_1799.field_8037;
    private final UUID ringerUUID = UUID.randomUUID();
    private boolean changeCassetteTape;
    private boolean lidOpen;
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int cassetteWriteProgress;
    private int volume = 150;
    private boolean mute;
    private boolean playing;
    private long position;
    private boolean loop;
    private boolean loadingMusic;

    public CassetteDeckBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(IMPBlockEntities.CASSETTE_DECK.get(), blockPos, blockState);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, CassetteDeckBlockEntity blockEntity) {

        blockEntity.lidOpenProgressOld = blockEntity.lidOpenProgress;

        if (blockEntity.lidOpen) {
            if (blockEntity.lidOpenProgress < blockEntity.getLidOpenProgressAll())
                blockEntity.lidOpenProgress++;
        } else {
            if (blockEntity.lidOpenProgress > 0)
                blockEntity.lidOpenProgress--;
        }

        if (!level.method_8608()) {

            if (blockEntity.isPowered()) {
                if (blockEntity.monitor == MonitorType.OFF)
                    blockEntity.setMonitor(MonitorType.MENU);
            } else {
                if (blockEntity.monitor != MonitorType.OFF)
                    blockEntity.setMonitor(MonitorType.OFF);
            }

            if ((blockEntity.getMusic() == null || blockEntity.getCassetteTape().method_7960() || IMPItemUtil.isAntenna(blockEntity.getCassetteTape())) && blockEntity.monitor == MonitorType.WRITE_EXECUTION)
                blockEntity.setMonitor(MonitorType.WRITE);

            if (blockEntity.monitor == MonitorType.WRITE_EXECUTION) {
                if (blockEntity.getCassetteWriteProgress() >= blockEntity.getCassetteWriteProgressAll()) {
                    blockEntity.writeCassetteTape();
                    blockEntity.setMonitor(MonitorType.WRITE);
                    blockEntity.setCassetteWriteProgress(0);
                } else {
                    blockEntity.setCassetteWriteProgress(blockEntity.getCassetteWriteProgress() + 1);
                }
            } else {
                if (blockEntity.getCassetteWriteProgress() != 0)
                    blockEntity.setCassetteWriteProgress(0);
            }

            if (blockEntity.monitor != MonitorType.PLAYBACK || !blockEntity.hasMusicCassetteTape()) {
                blockEntity.setRingerPosition(0);
                if (blockEntity.isPlaying())
                    blockEntity.setPlaying(false);
            }

            if (blockEntity.changeCassetteTape) {
                if (!blockEntity.isLidOpen())
                    blockEntity.startLidOpen(true);

                if (blockEntity.lidOpenProgress >= blockEntity.getLidOpenProgressAll()) {
                    blockEntity.changeCassetteTape = false;
                    blockEntity.startLidOpen(false);
                }
            }
            blockEntity.loadingMusic = blockEntity.isRingerWait();
            blockEntity.ringerTick();
            blockEntity.sync();
        }
    }

    private boolean canWriteCassetteTape() {
        return getMusic() != null && !getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    private void writeCassetteTape() {
        if (canWriteCassetteTape()) {
            CassetteTapeItem.setMusic(getCassetteTape(), getMusic());
            method_5431();
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.lidOpen = tag.method_10577("LidOpen");
        if (this.lidOpen)
            lidOpenProgress = getLidOpenProgressAll();
        this.monitor = MonitorType.getByName(tag.method_10558("Monitor"));
        IMPNbtUtil.readUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (tag.method_10545("Music"))
            this.music = OENbtUtil.readSerializable(tag, "Music", new Music());
        this.cassetteWriteProgress = tag.method_10550("CassetteWriteProgress");
        this.volume = tag.method_10550("Volume");
        this.mute = tag.method_10577("Mute");
        this.playing = tag.method_10577("Playing");
        this.position = tag.method_10537("Position");
        this.loop = tag.method_10577("Loop");
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10582("Monitor", monitor.getName());
        IMPNbtUtil.writeUUIDMap(tag, "PlayerSelectPlaylists", playerSelectPlaylists);
        if (this.music != null)
            OENbtUtil.writeSerializable(tag, "Music", music);
        tag.method_10569("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Mute", this.mute);
        tag.method_10556("Playing", this.playing);
        tag.method_10544("Position", this.position);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("LoadingMusic", this.loadingMusic);
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10566("OldCassetteTape", this.oldCassetteTape.method_7953(new class_2487()));
        tag.method_10556("ChangeCassetteTape", this.changeCassetteTape);
        tag.method_10582("Monitor", monitor.getName());
        if (playerSelectPlaylists.containsKey(player.method_7334().getId()))
            tag.method_25927("PlayerSelectPlaylist", playerSelectPlaylists.get(player.method_7334().getId()));
        if (this.music != null)
            OENbtUtil.writeSerializable(tag, "Music", music);
        tag.method_10569("CassetteWriteProgress", this.cassetteWriteProgress);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Mute", this.mute);
        tag.method_10556("Playing", this.playing);
        tag.method_10544("Position", this.position);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("LoadingMusic", this.loadingMusic);
        return super.getSyncData(player, tag);
    }

    @Override
    public void method_5447(int i, class_1799 stack) {
        if (i == 0)
            onCassetteTapeChange(stack, getCassetteTape());
        setItemNoChange(i, stack);
    }

    public void setItemNoChange(int i, class_1799 stack) {
        super.method_5447(i, stack);
    }

    public boolean isLoadingMusic() {
        return loadingMusic;
    }

    @Override
    public void onSync(class_2487 tag) {
        super.onSync(tag);
        this.lidOpen = tag.method_10577("LidOpen");
        this.oldCassetteTape = class_1799.method_7915(tag.method_10562("OldCassetteTape"));
        this.changeCassetteTape = tag.method_10577("ChangeCassetteTape");
        this.monitor = MonitorType.getByName(tag.method_10558("Monitor"));
        if (tag.method_10545("PlayerSelectPlaylist"))
            this.myPlayerSelectPlaylist = tag.method_25926("PlayerSelectPlaylist");
        if (tag.method_10545("Music"))
            this.music = OENbtUtil.readSerializable(tag, "Music", new Music());
        else
            this.music = null;
        this.cassetteWriteProgress = tag.method_10550("CassetteWriteProgress");
        this.volume = tag.method_10550("Volume");
        this.mute = tag.method_10577("Mute");
        this.playing = tag.method_10577("Playing");
        this.position = tag.method_10537("Position");
        this.loop = tag.method_10577("Loop");
        this.loadingMusic = tag.method_10577("LoadingMusic");
    }

    public boolean isLoop() {
        return loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        method_5431();
    }

    public long getPosition() {
        return position;
    }

    public void setPosition(long position) {
        this.position = position;
        method_5431();
    }

    public boolean isPlaying() {
        return playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
        method_5431();
    }

    public boolean isMute() {
        return mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        method_5431();
    }

    public int getVolume() {
        return volume;
    }

    public void setVolume(int volume) {
        if (this.volume != volume)
            setMute(false);
        this.volume = class_3532.method_15340(volume, 0, 300);
        method_5431();
    }

    public UUID getMyPlayerSelectPlaylist() {
        return myPlayerSelectPlaylist;
    }

    public void setPlayerSelectPlayList(class_3222 player, UUID uuid) {
        if (uuid != null)
            this.playerSelectPlaylists.put(player.method_7334().getId(), uuid);
        else
            this.playerSelectPlaylists.remove(player.method_7334().getId());
        method_5431();
    }

    public int getCassetteWriteProgress() {
        return cassetteWriteProgress;
    }

    public void setCassetteWriteProgress(int cassetteWriteProgress) {
        this.cassetteWriteProgress = cassetteWriteProgress;
        if (!getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(getCassetteTape())) {
            CassetteTapeItem.setTapePercentage(getCassetteTape(), (float) cassetteWriteProgress / (float) getCassetteWriteProgressAll());
        }
        method_5431();
    }

    public int getLidOpenProgressAll() {
        return 10;
    }

    public MonitorType getMonitor() {
        return monitor;
    }

    public float getLidOpenProgress(float partialTicks) {
        return class_3532.method_16439(partialTicks, lidOpenProgressOld, lidOpenProgress);
    }

    public void startLidOpen(boolean open) {
        setLidOpen(open);
        field_11863.method_8396(null, method_11016(), isLidOpen() ? class_3417.field_14664 : class_3417.field_14541, class_3419.field_15245, 0.5F, 0.4F / (field_11863.method_8409().nextFloat() * 0.4F + 0.8F));
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        method_5431();
    }

    public boolean isLidOpen() {
        return lidOpen;
    }

    public boolean isChangeCassetteTape() {
        return changeCassetteTape;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return items;
    }

    @Override
    protected class_2561 method_17823() {
        return IMPBlocks.CASSETTE_DECK.get().method_9518();
    }

    @Override
    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new CassetteDeckMenu(i, inventory, method_11016(), this);
    }

    @Override
    public boolean method_5437(int i, class_1799 itemStack) {
        if (i == 0)
            return IMPItemUtil.isCassetteTape(itemStack);
        return super.method_5437(i, itemStack);
    }

    public Music getMusic() {
        return music;
    }

    public class_1799 getCassetteTape() {
        return method_5438(0);
    }

    public class_1799 getOldCassetteTape() {
        return oldCassetteTape;
    }

    protected void onCassetteTapeChange(class_1799 newItem, class_1799 oldItem) {
        if (monitor == MonitorType.WRITE_EXECUTION)
            setMonitor(MonitorType.WRITE);
        setRingerPosition(0);
        setPlaying(false);

        this.oldCassetteTape = oldItem;
        this.changeCassetteTape = true;
    }

    public void setMusic(Music music) {
        this.music = music;
        method_5431();
    }

    public int getCassetteWriteProgressAll() {
        return 200;
    }

    public void setMonitor(MonitorType monitor) {
        this.monitor = monitor;
        method_5431();
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        if ("monitor".equals(name)) {
            this.monitor = MonitorType.getByName(data.method_10558("name"));
            if (this.monitor == MonitorType.WRITE_EXECUTION && canWriteCassetteTape())
                IMPCriteriaTriggers.WRITE_CASSETTE_TAPE.trigger(player, getCassetteTape());
            return null;
        } else if ("select_playlist".equals(name)) {
            if (data.method_10545("uuid")) {
                var uuid = data.method_25926("uuid");
                var pl = MusicManager.getInstance().getSaveData().getPlayLists().get(uuid);
                if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly())
                    setPlayerSelectPlayList(player, uuid);
            } else {
                setPlayerSelectPlayList(player, null);
            }
            return null;
        } else if ("set_music".equals(name)) {
            if (data.method_10545("music")) {
                var mm = MusicManager.getInstance();
                var m = mm.getSaveData().getMusics().get(data.method_25926("music"));
                if (m != null) {
                    var pl = mm.getPlaylistByMusic(m.getUuid());
                    if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly())
                        setMusic(m);
                }
            }
            return null;
        } else if ("set_volume".equals(name)) {
            if (isPowered())
                setVolume(data.method_10550("volume"));
        } else if ("set_mute".equals(name)) {
            if (isPowered())
                setMute(data.method_10577("mute"));
        } else if ("set_playing".equals(name)) {
            if (isPowered()) {
                boolean pl = data.method_10577("playing");
                setPlaying(pl);
                if (!pl)
                    setRingerPosition(0);
            }
        } else if ("set_pause".equals(name)) {
            if (isPowered())
                setPlaying(false);
        } else if ("restat_and_set_position".equals(name)) {
            if (isPowered())
                setMusicPositionAndRestart(data.method_10537("position"));
            return null;
        } else if ("set_loop".equals(name)) {
            if (isPowered())
                setLoop(data.method_10577("loop"));
        }
        return super.onInstruction(player, name, num, data);
    }

    public void setMusicPositionAndRestart(long position) {
        setRingerPosition(position);
        ringerRestart();
    }

    @Override
    public class_2561 getRingerName() {
        return method_17823();
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218) field_11863;
    }

    @Override
    public UUID getRingerUUID() {
        return ringerUUID;
    }

    @Override
    public boolean exists() {
        if (method_10997() == null || field_11863 != method_10997()) return false;
        return method_11016() != null && field_11863.method_8321(method_11016()) == this;
    }

    @Override
    public boolean isRingerPlaying() {
        return isPlaying();
    }

    @Override
    public void setRingerPlaying(boolean playing) {
        setPlaying(playing);
    }

    private boolean hasCassetteTape() {
        return !getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(getCassetteTape());
    }

    private boolean hasMusicCassetteTape() {
        return hasCassetteTape() && CassetteTapeItem.getMusic(getCassetteTape()) != null;
    }

    @Override
    public @Nullable MusicSource getRingerMusicSource() {
        return hasMusicCassetteTape() ? CassetteTapeItem.getMusic(getCassetteTape()).getSource() : null;
    }

    @Override
    public boolean isRingerLoop() {
        return isLoop();
    }

    @Override
    public long getRingerPosition() {
        return getPosition();
    }

    @Override
    public void setRingerPosition(long position) {
        setPosition(position);
        if (hasMusicCassetteTape()) {
            var m = getRingerMusicSource();
            if (m != null) {
                var nc = CassetteTapeItem.setTapePercentage(getCassetteTape().method_7972(), (float) position / (float) m.getDuration());
                setItemNoChange(0, nc);
            }
        }
        method_5431();
    }

    @Override
    public MusicTrackerEntry getRingerTracker() {
        return IMPMusicTrackers.createFixedTracker(getRingerSpatialPosition(), getRingerVolume(), getRingerRange());
    }

    @Override
    public @NotNull class_243 getRingerSpatialPosition() {
        return new class_243(method_11016().method_10263() + 0.5, method_11016().method_10264() + 0.5, method_11016().method_10260() + 0.5);
    }

    public float getRawVolume() {
        return (float) getVolume() / 300f;
    }

    @Override
    public float getRingerVolume() {
        return getRawVolume();
    }

    @Override
    public float getRingerRange() {
        return 90f * getRawVolume();
    }

    @Override
    public boolean isRingerStream() {
        return false;
    }

    @Override
    public boolean isRingerMute() {
        return isMute();
    }

    public static enum MonitorType {
        OFF("off"),
        MENU("menu"),
        WRITE("write"),
        PLAYBACK("playback"),
        WRITE_EXECUTION("write_execution");
        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : values()) {
                if (value.getName().equals(name))
                    return value;
            }
            return MonitorType.OFF;
        }
    }
}
