package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import var;

public class MusicLoaderTypesFixedButtonsList extends FixedButtonsList<String> implements IIMPSmartRender {
    public static final class_2960 UPLOAD_ICON = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/music_manager/loader_types/upload.png");
    private final Function<String, Boolean> selected;

    public MusicLoaderTypesFixedButtonsList(int x, int y, int w, int h, int num, class_2561 name, List<String> list, PressEntry<String> onPressEntry, Function<String, Boolean> selected) {
        super(x, y, w, h, MusicManagerMonitor.WIDGETS_TEXTURE, 0, 20, 256, 256, num, name, list, n -> {
            var lt = IMPMusicMedias.getMedia(n);
            return lt == null ? new class_2588("imp.loaderType." + n) : lt.getMediaName();
        }, onPressEntry);
        this.selected = selected;
    }

    @Override
    protected void renderOneButton(class_4587 poseStack, String item, int lnum, int bnum, int x, int y, int mx, int my, float parTick) {
        drawSmartButtonBox(poseStack, x, y, getOneButtonWidth(), getOneButtonHeight(), selected.apply(item) ? 0 : this.method_25356(this.isHoveredOrFocused(bnum)));
        var type = IMPMusicMedias.getMedia(item);
        int tx = x + 2;
        if ((type != null && type.getIcon() != null) || "upload".equals(item)) {
            var icon = type != null ? type.getIcon() : UPLOAD_ICON;
            OERenderUtil.drawTexture(icon, poseStack, x + 1, y + 1, 0, 0, getOneButtonHeight() - 2, getOneButtonHeight() - 2, getOneButtonHeight() - 2, getOneButtonHeight() - 2);
            tx += getOneButtonHeight() - 1;
        }
        drawSmartFixedWidthText(poseStack, getMessage(lnum), tx, y + (getOneButtonHeight() - 6.5f) / 2f, getOneButtonWidth() - 2 - getOneButtonHeight() - 1);
    }
}
