package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.IMPMusicTrackerFactory;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import org.jetbrains.annotations.Nullable;
import var;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class MusicManagerScreen extends IMPBaseContainerScreen<MusicManagerMenu> {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 BG_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/music_manager/music_manager_base.png");
    private final Map<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor> monitors = new HashMap<>();
    private final UUID musicPlayerId = UUID.randomUUID();
    public boolean lastSearch;
    protected MusicManagerMonitor monitor;
    public byte[] musicFileImage;

    public MusicManagerScreen(MusicManagerMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 386;
        this.field_2779 = 227;
        this.bgTextureWidth = 512;
        this.bgTextureHeight = 512;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new PowerButton(this, field_2776 + 368, field_2800 + 4, 12, 12, 386, 0, BG_TEXTURE, bgTextureWidth, bgTextureHeight));
        changeScreenMonitor(getBEMonitorType());
        insMonitor(getBEMonitorType());
    }

    public void insMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (monitor != null && monitor.getType() != type)
            stopMusic();

        var tag = new class_2487();
        tag.putString("type", type.getName());
        instruction("set_monitor", 0, tag);
    }

    public void insAddPlayList(UUID playListId) {
        var tag = new class_2487();
        tag.putUUID("playlist", playListId);
        instruction("add_playlist", 0, tag);
    }

    private void changeScreenMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (monitor != null) {
            if (monitor.getType() != MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC || type != MusicManagerBlockEntity.MonitorType.ADD_MUSIC)
                musicFileImage = null;
            monitor.renderables.forEach(n -> {
                if (n instanceof class_364 guiEventListener)
                    method_37066(guiEventListener);
            });
            monitor.depose();
        }

        if (!monitors.containsKey(type))
            monitors.put(type, MusicManagerMonitor.createdMusicMonitor(type, this));

        monitor = monitors.get(type);
        monitor.init(field_2776, field_2800);
        monitor.renderables.forEach(n -> {
            if (n instanceof class_339 widget)
                method_37063(widget);
        });
    }

    private MusicManagerBlockEntity.MonitorType getBEMonitorType() {
        if (getBlockEntity() instanceof MusicManagerBlockEntity musicManagerBlockEntity)
            return musicManagerBlockEntity.getMyMonitor(mc.field_1724);
        return MusicManagerBlockEntity.MonitorType.OFF;
    }

    public void insImportPlayListMusicCount(int count) {
        var tag = new class_2487();
        tag.putInt("count", count);
        instruction("set_import_playlist_music_count", 0, tag);
    }

    public void insImportPlayListAuthor(String author) {
        var tag = new class_2487();
        tag.putString("author", author);
        instruction("set_import_playlist_author", 0, tag);
    }

    public void insImportPlayListName(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_import_playlist_name", 0, tag);
    }

    public void insImportIdentifier(String identifier) {
        var tag = new class_2487();
        tag.putString("id", identifier);
        instruction("set_import_identifier", 0, tag);
    }

    public void insImageURL(String url) {
        var tag = new class_2487();
        tag.putString("url", url);
        instruction("set_image_url", 0, tag);
    }

    public void insImage(ImageInfo image) {
        var tag = new class_2487();
        OENbtUtil.writeSerializable(tag, "image", image);
        instruction("set_image", 0, tag);
    }

    public void insCreateName(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_create_name", 0, tag);
    }

    public void insPublishing(String publishing) {
        var tag = new class_2487();
        tag.putString("publishing", publishing);
        instruction("set_publishing", 0, tag);
    }

    public void insInitialAuthority(String initialAuthority) {
        var tag = new class_2487();
        tag.putString("initial_authority", initialAuthority);
        instruction("set_initial_authority", 0, tag);
    }

    public void insInvitePlayerName(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_invite_player_name", 0, tag);
    }

    public void insInvitePlayers(List<UUID> players) {
        var tag = new class_2487();
        OENbtUtil.writeUUIDList(tag, "players", players);
        instruction("set_invite_players", 0, tag);
    }

    public void insSelectedPlayList(UUID selectedPlayList) {
        var tag = new class_2487();
        if (selectedPlayList != null)
            tag.putUUID("playlist", selectedPlayList);
        instruction("set_selected_playlist", 0, tag);
    }

    public void insSelectedMusic(@Nullable UUID selectedMusic) {
        var tag = new class_2487();
        if (selectedMusic != null)
            tag.putUUID("music", selectedMusic);
        instruction("set_selected_music", 0, tag);
    }

    public void insSelectedPlayer(@Nullable UUID selectedPlayer) {
        var tag = new class_2487();
        if (selectedPlayer != null)
            tag.putUUID("player", selectedPlayer);
        instruction("set_selected_player", 0, tag);
    }

    public void insMusicLoaderType(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_music_loader_type", 0, tag);
    }

    public void insMusicSourceName(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_music_source_name", 0, tag);
    }

    public void insMusicSource(MusicSource source) {
        if (source == null)
            source = MusicSource.EMPTY;
        var tag = new class_2487();
        OENbtUtil.writeSerializable(tag, "MusicSource", source);
        instruction("set_music_source", 0, tag);
    }

    public void insMusicSearchName(String name) {
        var tag = new class_2487();
        tag.putString("name", name);
        instruction("set_music_search_name", 0, tag);
    }

    public void insMusicAuthor(String author) {
        var tag = new class_2487();
        tag.putString("author", author);
        instruction("set_music_author", 0, tag);
    }

    @Override
    public void onInstructionReturn(String name, int num, class_2487 data) {
        super.onInstructionReturn(name, num, data);
        if ("add_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                insSelectedPlayList(data.method_25926("playlist"));
            }
        } else if ("set_selected_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                monitor.onUpdateSelectedPlayList(data.method_25926("playlist"));
            } else {
                monitor.onUpdateSelectedPlayList(null);
            }
        }
    }

    @Override
    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    @Override
    protected void method_2388(class_4587 poseStack, int i, int j) {
        this.field_22793.method_30883(poseStack, this.field_22785, (float) this.field_25267, (float) this.field_25268, 4210752);
    }

    @Override
    protected void method_2389(class_4587 poseStack, float f, int i, int j) {
        super.method_2389(poseStack, f, i, j);
        if (monitor != null)
            monitor.render(poseStack, f, i, j);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (monitor != null) {
            if (getBEMonitorType() != monitor.getType())
                changeScreenMonitor(getBEMonitorType());
            monitor.tick();
        }
    }

    @Override
    public void method_25419() {
        super.method_25419();
        if (monitor != null)
            monitor.depose();

        stopMusic();
    }

    @Override
    public void method_29638(List<Path> list) {
        if (monitor != null)
            monitor.onFilesDrop(list);
    }

    public void playMusic(MusicSource source, long postion) {
        stopMusic();
        getMusicEngine().loadAndPlay(musicPlayerId, source, postion, false);
        getMusicEngine().addSpeaker(musicPlayerId, musicPlayerId, IMPMusicTrackerFactory.linked(IMPMusicTrackers.createPlayerTracker(mc.field_1724, 1, 10)));
    }

    public void stopMusic() {
        getMusicEngine().stop(musicPlayerId);
    }

    public boolean isMusicPlaying() {
        return getMusicEngine().isPlaying(musicPlayerId);
    }

    public boolean isMusicLoading() {
        return getMusicEngine().isLoading(musicPlayerId);
    }

    private MusicEngine getMusicEngine() {
        return MusicEngine.getInstance();
    }

    public MusicEntry getMusicPlayer() {
        return getMusicEngine().getMusicEntry(musicPlayerId);
    }
}
