package dev.felnull.imp.client.gui.screen.monitor.cassette_deck;

import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.CassetteDeckScreen;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class MenuCDMonitor extends CassetteDeckMonitor {
    private static final class_2561 WRITE = new class_2588("imp.button.write");
    private static final class_2561 PLAYBACK = new class_2588("imp.button.playback");

    public MenuCDMonitor(CassetteDeckBlockEntity.MonitorType monitorType, CassetteDeckScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(getStartX() + (width - 100) / 2, getStartY() + (height - 14 * 3) / 2, 100, 14, WRITE, n -> {
            insMonitor(CassetteDeckBlockEntity.MonitorType.WRITE);
        }));

        this.addRenderWidget(new SmartButton(getStartX() + (width - 100) / 2, getStartY() + (height - 14 * 3) / 2 + 14 * 2, 100, 14, PLAYBACK, n -> {
            insMonitor(CassetteDeckBlockEntity.MonitorType.PLAYBACK);
        }));
    }

    @Override
    public void renderAppearance(CassetteDeckBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float) width;
        float onPxH = monitorHeight / (float) height;
        renderSmartButtonSprite(poseStack, multiBufferSource, (width - 100f) / 2f, (height - 14f * 3f) / 2f, OERenderUtil.MIN_BREADTH * 2, 100, 14, i, j, onPxW, onPxH, monitorHeight, WRITE, true);
        renderSmartButtonSprite(poseStack, multiBufferSource, (width - 100f) / 2f, (height - 14f * 3f) / 2f + 14f * 2f, OERenderUtil.MIN_BREADTH * 2, 100, 14, i, j, onPxW, onPxH, monitorHeight, PLAYBACK, true);
    }
}
