package dev.felnull.imp.client.music;

import dev.felnull.imp.music.tracker.*;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class IMPMusicTrackerFactory {
    private static final class_310 mc = class_310.method_1551();
    private static final Map<class_2960, Supplier<? extends MusicTracker>> FACTORY_REGISTRY = new HashMap<>();

    public static void init() {
        register(IMPMusicTrackers.FIXED_TRACKER, FixedMusicTracker::new);
        register(IMPMusicTrackers.ENTITY_TRACKER, () -> new EntityMusicTracker(mc.field_1687, OERenderUtil::getPartialTicks));
        register(IMPMusicTrackers.PLAYER_TRACKER, () -> new PlayerMusicTracker(mc.field_1724, mc.field_1687, OERenderUtil::getPartialTicks));
    }

    public static void register(class_2960 location, Supplier<? extends MusicTracker> factory) {
        FACTORY_REGISTRY.put(location, factory);
    }

    public static MusicTracker create(class_2960 location) {
        return FACTORY_REGISTRY.get(location).get();
    }

    @Nullable
    public static MusicTracker loadByTag(class_2487 tag) {
        if (tag.method_33133())
            return null;
        var id = new class_2960(tag.method_10558("trackerId"));
        return OENbtUtil.readSerializable(tag, "tracker", create(id));
    }

    public static MusicTracker linked(MusicTrackerEntry trackerEntry) {
        var tag = IMPMusicTrackers.saveToTag(trackerEntry);
        return loadByTag(tag);
    }
}
